/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.util.List;
import proguard.ClassSpecification;
import proguard.MemberSpecification;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.MemberVisitor;

public class ClassMemberChecker
extends SimplifiedVisitor
implements MemberVisitor {
    private final ClassPool programClassPool;
    private final WarningPrinter notePrinter;

    public ClassMemberChecker(ClassPool programClassPool, WarningPrinter notePrinter) {
        this.programClassPool = programClassPool;
        this.notePrinter = notePrinter;
    }

    public void checkClassSpecifications(List classSpecifications) {
        if (classSpecifications != null) {
            for (int index = 0; index < classSpecifications.size(); ++index) {
                Clazz clazz;
                ClassSpecification classSpecification = (ClassSpecification)classSpecifications.get(index);
                String className = classSpecification.className;
                if (className == null || ClassMemberChecker.containsWildCards(className) || !this.notePrinter.accepts(className) || (clazz = this.programClassPool.getClass(className)) == null) continue;
                this.checkMemberSpecifications(clazz, classSpecification.fieldSpecifications, true);
                this.checkMemberSpecifications(clazz, classSpecification.methodSpecifications, false);
            }
        }
    }

    private void checkMemberSpecifications(Clazz clazz, List memberSpecifications, boolean isField) {
        if (memberSpecifications != null) {
            String className = clazz.getName();
            for (int index = 0; index < memberSpecifications.size(); ++index) {
                MemberSpecification memberSpecification = (MemberSpecification)memberSpecifications.get(index);
                String memberName = memberSpecification.name;
                String descriptor = memberSpecification.descriptor;
                if (memberName == null || ClassMemberChecker.containsWildCards(memberName) || descriptor == null || ClassMemberChecker.containsWildCards(descriptor)) continue;
                if (isField) {
                    if (clazz.findField(memberName, descriptor) != null) continue;
                    this.notePrinter.print(className, "Note: the configuration refers to the unknown field '" + ClassUtil.externalFullFieldDescription(0, memberName, descriptor) + "' in class '" + ClassUtil.externalClassName(className) + "'");
                    continue;
                }
                if (clazz.findMethod(memberName, descriptor) != null) continue;
                this.notePrinter.print(className, "Note: the configuration refers to the unknown method '" + ClassUtil.externalFullMethodDescription(className, 0, memberName, descriptor) + "' in class '" + ClassUtil.externalClassName(className) + "'");
            }
        }
    }

    private static boolean containsWildCards(String string) {
        return string != null && (string.indexOf(33) >= 0 || string.indexOf(42) >= 0 || string.indexOf(63) >= 0 || string.indexOf(44) >= 0 || string.indexOf("///") >= 0);
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        System.out.println("      Maybe you meant the field '" + ClassUtil.externalFullFieldDescription(0, programField.getName(programClass), programField.getDescriptor(programClass)) + "'?");
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        System.out.println("      Maybe you meant the method '" + ClassUtil.externalFullMethodDescription(programClass.getName(), 0, programMethod.getName(programClass), programMethod.getDescriptor(programClass)) + "'?");
    }
}

