/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.config;

import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.context.ApplicationContext;

public class ReloadableScope
implements Scope {
    @Nonnull
    @NotEmpty
    public static final String SCOPE_RELOADABLE = "reloadable";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ReloadableScope.class);
    @Nonnull
    private final ReloadableService<ApplicationContext> reloadableService;

    public ReloadableScope(@Nonnull @ParameterName(name="service") ReloadableService<ApplicationContext> service) {
        this.reloadableService = (ReloadableService)Constraint.isNotNull(service, (String)"ReloadableService cannot be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String name, ObjectFactory<?> objectFactory) {
        this.log.debug("Accessing reloadable bean instance '{}'", (Object)name);
        ServiceableComponent component = this.reloadableService.getServiceableComponent();
        try {
            Object object = ((ApplicationContext)component.getComponent()).getBean(name);
            return object;
        }
        finally {
            component.unpinComponent();
        }
    }

    public Object remove(String name) {
        throw new UnsupportedOperationException("No support for object removal");
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        this.log.warn("Ignoring unsupported destruction callback for '{}'", (Object)name);
    }

    public Object resolveContextualObject(String key) {
        return null;
    }

    public String getConversationId() {
        return null;
    }
}

