/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.factory;

import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;

public class DOMDocumentFactoryBean
implements FactoryBean<Document> {
    @Nullable
    private Resource resource;
    @Nullable
    private ParserPool parserPool;
    @Nullable
    private Document document;

    public void setResource(@Nonnull Resource domResource) {
        this.resource = (Resource)Constraint.isNotNull((Object)domResource, (String)"resource cannot be null");
    }

    public void setParserPool(@Nonnull ParserPool pool) {
        this.parserPool = (ParserPool)Constraint.isNotNull((Object)pool, (String)"ParserPool cannot be null");
    }

    @Nonnull
    public synchronized Document getObject() throws Exception {
        if (this.document == null) {
            if (this.resource == null) {
                throw new BeanCreationException("Document resource must be provided in order to use this factory.");
            }
            if (this.parserPool == null) {
                throw new BeanCreationException("ParserPool must be provided in order to use this factory.");
            }
            try (InputStream is = this.resource.getInputStream();){
                this.document = this.parserPool.parse(is);
            }
        }
        return this.document;
    }

    @Nonnull
    public Class<?> getObjectType() {
        return Document.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

