/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.factory;

import javax.annotation.Nullable;
import net.shibboleth.ext.spring.factory.AbstractComponentAwareFactoryBean;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.httpclient.HttpClientBuilder;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;

public class HttpClientFactoryBean
extends AbstractComponentAwareFactoryBean<HttpClient> {
    private final HttpClientBuilder builder = this.createHttpClientBuilder();
    @Duration
    private long connectionTimeout;
    @Duration
    private long connectionRequestTimeout;
    @Duration
    private long socketTimeout;

    public Class<HttpClient> getObjectType() {
        return HttpClient.class;
    }

    public void setMaxConnectionsTotal(int max) {
        this.builder.setMaxConnectionsTotal(max);
    }

    public void setMaxConnectionsPerRoute(int max) {
        this.builder.setMaxConnectionsPerRoute(max);
    }

    @Duration
    public void setConnectionTimeout(@Duration long timeout) {
        this.connectionTimeout = timeout;
        if (timeout > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Timeout was too large");
        }
        this.builder.setConnectionTimeout((long)((int)timeout));
    }

    @Duration
    public void setConnectionRequestTimeout(@Duration long timeout) {
        this.connectionRequestTimeout = timeout;
        if (timeout > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Timeout was too large");
        }
        this.builder.setConnectionRequestTimeout((long)((int)timeout));
    }

    @Duration
    public void setSocketTimeout(@Duration long timeout) {
        this.socketTimeout = timeout;
        if (timeout > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Timeout was too large");
        }
        this.builder.setSocketTimeout((long)((int)timeout));
    }

    public void setTLSSocketFactory(@Nullable LayeredConnectionSocketFactory factory) {
        this.builder.setTLSSocketFactory(factory);
    }

    public void setConnectionDisregardTLSCertificate(boolean disregard) {
        this.builder.setConnectionDisregardTLSCertificate(disregard);
    }

    public void setConnectionProxyHost(@Nullable String host) {
        this.builder.setConnectionProxyHost(host);
    }

    public void setConnectionProxyPort(int port) {
        this.builder.setConnectionProxyPort(port);
    }

    public void setConnectionProxyUsername(@Nullable String usename) {
        this.builder.setConnectionProxyUsername(usename);
    }

    public void setConnectionProxyPassword(@Nullable String password) {
        this.builder.setConnectionProxyPassword(password);
    }

    public void setUserAgent(@Nullable String agent) {
        this.builder.setUserAgent(agent);
    }

    public void setDisableContentCompression(boolean disable) {
        this.builder.setDisableContentCompression(disable);
    }

    public void setDisableCookieManagement(boolean disable) {
        this.builder.setDisableCookieManagement(disable);
    }

    protected HttpClientBuilder createHttpClientBuilder() {
        return new HttpClientBuilder();
    }

    protected HttpClientBuilder getHttpClientBuilder() {
        return this.builder;
    }

    @Override
    protected HttpClient doCreateInstance() throws Exception {
        return this.builder.buildClient();
    }
}

