/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.resource;

import java.io.File;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import org.springframework.beans.factory.InitializingBean;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;

@ThreadSafe
public class SVNBasicAuthenticationManager
extends BasicAuthenticationManager
implements InitializingBean {
    private String proxyHost;
    private int proxyPort;
    private String proxyUserName;
    private String proxyPassword;
    private boolean proxySet;

    public SVNBasicAuthenticationManager(@ParameterName(name="") List<SVNAuthentication> authentications) {
        super(authentications.toArray(new SVNAuthentication[authentications.size()]));
    }

    @Deprecated
    public SVNBasicAuthenticationManager(@ParameterName(name="userName") String userName, @ParameterName(name="keyFile") File keyFile, @ParameterName(name="passphrase") String passphrase, @ParameterName(name="portNumber") int portNumber) {
        super(userName, keyFile, passphrase, portNumber);
        DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.CLASS, (String)SVNBasicAuthenticationManager.class.getName(), null, null);
    }

    public SVNBasicAuthenticationManager(@ParameterName(name="userName") String userName, @ParameterName(name="password") String password) {
        super(userName, password);
    }

    public void afterPropertiesSet() {
        if (this.proxySet) {
            this.setProxy(this.proxyHost, this.proxyPort, this.proxyUserName, this.proxyPassword);
        }
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String host) {
        this.proxyHost = host;
        this.proxySet = true;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int port) {
        this.proxyPort = port;
        this.proxySet = true;
    }

    public String getProxyUserName() {
        return this.proxyUserName;
    }

    public void setProxyUserName(String userName) {
        this.proxyUserName = userName;
        this.proxySet = true;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String password) {
        this.proxyPassword = password;
        this.proxySet = true;
    }
}

