/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.ext.spring.config.BooleanToPredicateConverter;
import net.shibboleth.ext.spring.config.DurationToLongConverter;
import net.shibboleth.ext.spring.config.StringBooleanToPredicateConverter;
import net.shibboleth.ext.spring.config.StringToIPRangeConverter;
import net.shibboleth.ext.spring.config.StringToResourceConverter;
import net.shibboleth.ext.spring.context.FilesystemGenericApplicationContext;
import net.shibboleth.ext.spring.resource.PreferFileSystemResourceLoader;
import net.shibboleth.ext.spring.util.SchemaTypeAwareXMLBeanDefinitionReader;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ConversionServiceFactoryBean;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class ApplicationContextBuilder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ApplicationContextBuilder.class);
    @Nullable
    @NotEmpty
    private String contextName;
    @Nullable
    @NonnullElements
    private List<Resource> configurationResources;
    @Nullable
    private ConversionService conversionService;
    @Nullable
    @NonnullElements
    private List<ApplicationContextInitializer<? super FilesystemGenericApplicationContext>> contextInitializers;
    @Nullable
    @NonnullElements
    private List<BeanFactoryPostProcessor> factoryPostProcessors;
    @Nullable
    @NonnullElements
    private List<BeanPostProcessor> postProcessors;
    @Nullable
    @NonnullElements
    private Collection<String> beanProfiles;
    @Nullable
    private ApplicationContext parentContext;

    @Nonnull
    public ApplicationContextBuilder setName(@Nullable @NotEmpty String name) {
        this.contextName = StringSupport.trimOrNull((String)name);
        return this;
    }

    @Nonnull
    public ApplicationContextBuilder setConversionService(@Nullable ConversionService service) {
        this.conversionService = service;
        return this;
    }

    @Nonnull
    public ApplicationContextBuilder setServiceConfiguration(@Nonnull Resource config) {
        this.configurationResources = Collections.singletonList(Constraint.isNotNull((Object)config, (String)"Resource cannot be null"));
        return this;
    }

    @Nonnull
    public ApplicationContextBuilder setServiceConfigurations(@Nonnull @NonnullElements List<Resource> configs) {
        this.configurationResources = new ArrayList<Resource>(Collections2.filter(configs, (Predicate)Predicates.notNull()));
        return this;
    }

    @Nonnull
    public ApplicationContextBuilder setContextInitializer(@Nonnull ApplicationContextInitializer<? super FilesystemGenericApplicationContext> initializer) {
        Constraint.isNotNull(initializer, (String)"ApplicationContextInitializer cannot be null");
        this.contextInitializers = Collections.singletonList(initializer);
        return this;
    }

    @Nonnull
    public ApplicationContextBuilder setContextInitializers(@Nonnull @NonnullElements List<ApplicationContextInitializer<? super FilesystemGenericApplicationContext>> initializers) {
        this.contextInitializers = new ArrayList<ApplicationContextInitializer<? super FilesystemGenericApplicationContext>>(Collections2.filter(initializers, (Predicate)Predicates.notNull()));
        return this;
    }

    @Nonnull
    public ApplicationContextBuilder setBeanFactoryPostProcessor(@Nonnull BeanFactoryPostProcessor processor) {
        Constraint.isNotNull((Object)processor, (String)"BeanFactoryPostProcessor cannot be null");
        this.factoryPostProcessors = Collections.singletonList(processor);
        return this;
    }

    @Nonnull
    public ApplicationContextBuilder setBeanFactoryPostProcessors(@Nonnull @NonnullElements List<BeanFactoryPostProcessor> processors) {
        this.factoryPostProcessors = new ArrayList<BeanFactoryPostProcessor>(Collections2.filter(processors, (Predicate)Predicates.notNull()));
        return this;
    }

    @Nonnull
    public ApplicationContextBuilder setBeanPostProcessor(@Nonnull BeanPostProcessor processor) {
        Constraint.isNotNull((Object)processor, (String)"BeanPostProcessor cannot be null");
        this.postProcessors = Collections.singletonList(processor);
        return this;
    }

    @Nonnull
    public ApplicationContextBuilder setBeanPostProcessors(@Nonnull @NonnullElements List<BeanPostProcessor> processors) {
        this.postProcessors = new ArrayList<BeanPostProcessor>(Collections2.filter(processors, (Predicate)Predicates.notNull()));
        return this;
    }

    @Nonnull
    public ApplicationContextBuilder setBeanProfiles(@Nonnull @NonnullElements Collection<String> profiles) {
        this.beanProfiles = StringSupport.normalizeStringCollection(profiles);
        return this;
    }

    @Nonnull
    public ApplicationContextBuilder setParentContext(@Nullable ApplicationContext context) {
        this.parentContext = context;
        return this;
    }

    @Nonnull
    public GenericApplicationContext build() {
        FilesystemGenericApplicationContext context = new FilesystemGenericApplicationContext(this.parentContext);
        context.setDisplayName("ApplicationContext:" + this.contextName != null ? this.contextName : "anonymous");
        context.setResourceLoader((ResourceLoader)new PreferFileSystemResourceLoader());
        if (this.conversionService != null) {
            context.getBeanFactory().setConversionService(this.conversionService);
        } else {
            ConversionServiceFactoryBean service = new ConversionServiceFactoryBean();
            service.setConverters(new HashSet<Converter>(Arrays.asList(new DurationToLongConverter(), new StringToIPRangeConverter(), new BooleanToPredicateConverter(), new StringBooleanToPredicateConverter(), new StringToResourceConverter())));
            service.afterPropertiesSet();
            context.getBeanFactory().setConversionService(service.getObject());
        }
        if (this.factoryPostProcessors != null) {
            for (BeanFactoryPostProcessor bfpp : this.factoryPostProcessors) {
                context.addBeanFactoryPostProcessor(bfpp);
            }
        }
        if (this.postProcessors != null) {
            for (BeanPostProcessor bpp : this.postProcessors) {
                context.getBeanFactory().addBeanPostProcessor(bpp);
            }
        }
        if (this.beanProfiles != null) {
            context.getEnvironment().setActiveProfiles(this.beanProfiles.toArray(new String[0]));
        }
        SchemaTypeAwareXMLBeanDefinitionReader beanDefinitionReader = new SchemaTypeAwareXMLBeanDefinitionReader((BeanDefinitionRegistry)context);
        if (this.configurationResources != null) {
            beanDefinitionReader.loadBeanDefinitions(this.configurationResources.toArray(new Resource[0]));
        }
        if (this.contextInitializers != null) {
            for (ApplicationContextInitializer<? super FilesystemGenericApplicationContext> initializer : this.contextInitializers) {
                initializer.initialize((ConfigurableApplicationContext)context);
            }
        }
        context.refresh();
        return context;
    }
}

