/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.log;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import com.google.common.base.StandardSystemProperty;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.Version;
import net.shibboleth.idp.log.LoggingService;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.service.AbstractReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceException;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class LogbackLoggingService
extends AbstractReloadableService<Object>
implements LoggingService,
ApplicationContextAware {
    private LoggerContext loggerContext;
    private StatusManager statusManager;
    @NonnullAfterInit
    private Resource fallbackConfiguration;
    @NonnullAfterInit
    private Resource configurationResource;
    @Nullable
    private ApplicationContext applicationContext;

    @NonnullAfterInit
    public Resource getLoggingConfiguration() {
        return this.configurationResource;
    }

    @Override
    public void setLoggingConfiguration(@Nonnull Resource configuration) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.configurationResource = (Resource)Constraint.isNotNull((Object)configuration, (String)"Logging configuration resource cannot be null");
    }

    public void setApplicationContext(ApplicationContext context) {
        this.applicationContext = context;
    }

    @Nullable
    public ServiceableComponent<Object> getServiceableComponent() {
        return null;
    }

    protected void doInitialize() throws ComponentInitializationException {
        if (this.configurationResource == null) {
            throw new ComponentInitializationException("Logging configuration must be specified.");
        }
        this.fallbackConfiguration = new ClassPathResource("/logback.xml");
        this.loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        this.statusManager = this.loggerContext.getStatusManager();
        if (!this.fallbackConfiguration.exists()) {
            if (this.isFailFast()) {
                throw new ComponentInitializationException(this.getLogPrefix() + "Cannot locate fallback logger");
            }
            this.statusManager.add((Status)new ErrorStatus("Cannot locate fallback logger at " + this.fallbackConfiguration.getDescription(), (Object)this));
        }
        super.doInitialize();
    }

    protected synchronized boolean shouldReload() {
        try {
            DateTime lastReload = this.getLastSuccessfulReloadInstant();
            if (null == lastReload) {
                return true;
            }
            return this.configurationResource.lastModified() > lastReload.getMillis();
        }
        catch (IOException e) {
            this.statusManager.add((Status)new ErrorStatus("Error checking last modified time of logging service configuration resource " + this.configurationResource.getDescription(), (Object)this, (Throwable)e));
            return false;
        }
    }

    protected synchronized void doReload() {
        this.loadLoggingConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void loadLoggingConfiguration() {
        InputStream ins = null;
        this.statusManager.add((Status)new InfoStatus("Loading new logging configuration resource: " + this.configurationResource.getDescription(), (Object)this));
        ins = this.configurationResource.getInputStream();
        this.loadLoggingConfiguration(ins);
        try {
            Closeables.close((Closeable)ins, (boolean)true);
        }
        catch (IOException e) {
            throw new ServiceException((Exception)e);
        }
        catch (Exception e) {
            try {
                try {
                    Closeables.close(ins, (boolean)true);
                }
                catch (IOException e1) {
                    throw new ServiceException((Exception)e1);
                }
                this.statusManager.add((Status)new ErrorStatus("Error loading logging configuration file: " + this.configurationResource.getDescription(), (Object)this, (Throwable)e));
                try {
                    this.statusManager.add((Status)new InfoStatus("Loading fallback logging configuration", (Object)this));
                    ins = this.fallbackConfiguration.getInputStream();
                    this.loadLoggingConfiguration(ins);
                }
                catch (IOException ioe) {
                    try {
                        Closeables.close((Closeable)ins, (boolean)true);
                    }
                    catch (IOException e1) {
                        throw new ServiceException((Exception)e1);
                    }
                    this.statusManager.add((Status)new ErrorStatus("Error loading fallback logging configuration", (Object)this, (Throwable)e));
                    throw new ServiceException("Unable to load fallback logging configuration");
                }
            }
            catch (Throwable throwable) {
                try {
                    Closeables.close(ins, (boolean)true);
                }
                catch (IOException e2) {
                    throw new ServiceException((Exception)e2);
                }
                throw throwable;
            }
            try {
                Closeables.close((Closeable)ins, (boolean)true);
            }
            catch (IOException e3) {
                throw new ServiceException((Exception)e3);
            }
        }
    }

    protected void loadLoggingConfiguration(InputStream loggingConfig) {
        try {
            this.loggerContext.reset();
            this.loadIdPHomeProperty();
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)this.loggerContext);
            configurator.doConfigure(loggingConfig);
            this.loggerContext.start();
            this.logImplementationDetails();
        }
        catch (JoranException e) {
            throw new ServiceException((Exception)((Object)e));
        }
    }

    protected void loadIdPHomeProperty() {
        String idpHome;
        if (this.applicationContext != null && (idpHome = this.applicationContext.getEnvironment().getProperty("idp.home")) != null) {
            this.statusManager.add((Status)new InfoStatus("Setting logger property 'idp.home' to '" + idpHome + "'", (Object)this));
            this.loggerContext.putProperty("idp.home", idpHome);
        }
    }

    protected void logImplementationDetails() {
        Logger logger = LoggerFactory.getLogger(LogbackLoggingService.class);
        logger.info("Shibboleth IdP Version {}", (Object)Version.getVersion());
        logger.info("Java version='{}' vendor='{}'", (Object)StandardSystemProperty.JAVA_VERSION.value(), (Object)StandardSystemProperty.JAVA_VENDOR.value());
        if (logger.isDebugEnabled()) {
            for (StandardSystemProperty standardSystemProperty : StandardSystemProperty.values()) {
                logger.debug("{}", (Object)standardSystemProperty);
            }
        }
    }
}

