/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.metrics.impl;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.Version;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import org.joda.time.DateTime;
import org.springframework.context.support.ApplicationObjectSupport;

public class IdPGaugeSet
extends ApplicationObjectSupport
implements MetricSet,
MetricFilter {
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_METRIC_NAME = "net.shibboleth.idp";
    @Nonnull
    @NonnullElements
    private final Map<String, Metric> gauges = new HashMap<String, Metric>();

    public IdPGaugeSet() {
        this.gauges.put(MetricRegistry.name((String)DEFAULT_METRIC_NAME, (String[])new String[]{"version"}), (Metric)new Gauge<String>(){

            public String getValue() {
                return Version.getVersion();
            }
        });
        this.gauges.put("org.opensaml.version", (Metric)new Gauge<String>(){

            public String getValue() {
                return org.opensaml.core.Version.getVersion();
            }
        });
        this.gauges.put(MetricRegistry.name((String)DEFAULT_METRIC_NAME, (String[])new String[]{"starttime"}), (Metric)new Gauge<DateTime>(){

            public DateTime getValue() {
                return new DateTime(IdPGaugeSet.this.getApplicationContext().getStartupDate());
            }
        });
        this.gauges.put(MetricRegistry.name((String)DEFAULT_METRIC_NAME, (String[])new String[]{"uptime"}), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return System.currentTimeMillis() - IdPGaugeSet.this.getApplicationContext().getStartupDate();
            }
        });
    }

    public Map<String, Metric> getMetrics() {
        return Collections.unmodifiableMap(this.gauges);
    }

    public boolean matches(String name, Metric metric) {
        return this.gauges.containsKey(name);
    }
}

