/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.config.logic;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.logic.AbstractRelyingPartyPredicate;
import net.shibboleth.idp.saml.saml1.profile.config.AttributeQueryProfileConfiguration;
import net.shibboleth.idp.saml.saml1.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;

public class IncludeAttributeStatementPredicate
extends AbstractRelyingPartyPredicate {
    @Nonnull
    private Function<ProfileRequestContext, SAMLBindingContext> bindingContextLookupStrategy = Functions.compose((Function)new ChildContextLookup(SAMLBindingContext.class), (Function)new OutboundMessageContextLookup());

    public void setBindingContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLBindingContext> strategy) {
        this.bindingContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLBindingContext lookup strategy cannot be null");
    }

    public boolean apply(@Nullable ProfileRequestContext input) {
        SAMLBindingContext bindingCtx = (SAMLBindingContext)this.bindingContextLookupStrategy.apply((Object)input);
        if (bindingCtx != null && bindingCtx.getBindingDescriptor() != null && bindingCtx.getBindingDescriptor().isArtifact()) {
            return true;
        }
        RelyingPartyContext rpc = (RelyingPartyContext)this.getRelyingPartyContextLookupStrategy().apply((Object)input);
        if (rpc != null && rpc.getProfileConfig() != null) {
            if (rpc.getProfileConfig() instanceof BrowserSSOProfileConfiguration) {
                return ((BrowserSSOProfileConfiguration)rpc.getProfileConfig()).getIncludeAttributeStatementPredicate().apply((Object)input);
            }
            if (rpc.getProfileConfig() instanceof net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration) {
                return ((net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration)rpc.getProfileConfig()).getIncludeAttributeStatementPredicate().apply((Object)input);
            }
            if (rpc.getProfileConfig() instanceof AttributeQueryProfileConfiguration) {
                return true;
            }
            if (rpc.getProfileConfig() instanceof net.shibboleth.idp.saml.saml2.profile.config.AttributeQueryProfileConfiguration) {
                return true;
            }
        }
        return false;
    }
}

