/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.shared.security;

import javax.annotation.Nullable;

/** Indicates the sealed data has expired. */
public class DataExpiredException extends DataSealerException {

    /**
     * serialVersionUID.
     */
    private static final long serialVersionUID = -4345061831894801408L;

    /**
     * Constructor.
     */
    public DataExpiredException() {
    }

    /**
     * Constructor.
     * 
     * @param message exception message
     */
    public DataExpiredException(@Nullable final String message) {
        super(message);
    }

    /**
     * Constructor.
     * 
     * @param wrappedException exception to be wrapped by this one
     */
    public DataExpiredException(@Nullable final Exception wrappedException) {
        super(wrappedException);
    }

    /**
     * Constructor.
     * 
     * @param message exception message
     * @param wrappedException exception to be wrapped by this one
     */
    public DataExpiredException(@Nullable final String message, @Nullable final Exception wrappedException) {
        super(message, wrappedException);
    }

}