/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.utilities.java.support.codec;

import javax.annotation.Nonnull;

import net.shibboleth.shared.codec.DecodingException;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.primitive.DeprecationSupport;
import net.shibboleth.shared.primitive.DeprecationSupport.ObjectType;

/**
 * Deprecated stub.
 * 
 * @deprecated
 */
@Deprecated(since="9.0.0", forRemoval=true)
public final class Base64Support {

    /** Constructor. */
    private Base64Support() {

    }

    /**
     * Base64 encodes the given binary data.
     * 
     * @param data data to encode
     * @param chunked whether the encoded data should be chunked or not
     * 
     * @return the base64 encoded data
     * @throws EncodingException when any {@link Exception} is thrown from the underlying encoder, 
     *                                  or the output is null.
     */
    @Nonnull public static String encode(@Nonnull final byte[] data, final boolean chunked) throws EncodingException{
        DeprecationSupport.warn(ObjectType.CLASS, Base64Support.class.getName(), null,
                net.shibboleth.shared.codec.Base64Support.class.getName());
        return net.shibboleth.shared.codec.Base64Support.encode(data, chunked);
    }

    /**
     * Decodes (un)chunked Base64 encoded data.
     * 
     * @param data Base64 encoded data
     * 
     * @return the decoded data
     * 
     * @throws DecodingException when any {@link Exception} is thrown from
     *                              the underlying decoder, or the output is null.
     */
    @Nonnull public static byte[] decode(@Nonnull final String data) throws DecodingException{
        DeprecationSupport.warn(ObjectType.CLASS, Base64Support.class.getName(), null,
                net.shibboleth.shared.codec.Base64Support.class.getName());
        return net.shibboleth.shared.codec.Base64Support.decode(data);
    }
    
    /**
     * Base64URL encodes the given binary data.
     * 
     * <p>
     * This is compliant with RFC 4648, Section 5: "Base 64 Encoding with URL and Filename Safe Alphabet".
     * </p>
     * 
     * @param data data to encode
     * 
     * @return the base64url encoded data
     * @throws EncodingException if the input data can not be encoded as a base64 string.
     */
    @Nonnull public static String encodeURLSafe(@Nonnull final byte[] data) throws EncodingException {
        DeprecationSupport.warn(ObjectType.CLASS, Base64Support.class.getName(), null,
                net.shibboleth.shared.codec.Base64Support.class.getName());
        return net.shibboleth.shared.codec.Base64Support.encodeURLSafe(data);
    }

    /**
     * Decodes (un)chunked Base64URL encoded data.
     * 
     * <p>
     * This is compliant with RFC 4648, Section 5: "Base 64 Encoding with URL and Filename Safe Alphabet".
     * </p>
     * 
     * @param data Base64URL encoded data
     * 
     * @return the decoded data
     * 
     * @throws DecodingException if unable to decode the input data.
     */
    @Nonnull public static byte[] decodeURLSafe(@Nonnull final String data) throws DecodingException {
        DeprecationSupport.warn(ObjectType.CLASS, Base64Support.class.getName(), null,
                net.shibboleth.shared.codec.Base64Support.class.getName());
        return net.shibboleth.shared.codec.Base64Support.decodeURLSafe(data);
    }

}