/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.loader;

import com.opensymphony.workflow.InvalidWorkflowDescriptorException;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ConditionalResultDescriptor;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.RestrictionDescriptor;
import com.opensymphony.workflow.loader.ResultDescriptor;
import com.opensymphony.workflow.loader.ValidationHelper;
import com.opensymphony.workflow.loader.ValidatorDescriptor;
import com.opensymphony.workflow.loader.XMLUtil;
import com.opensymphony.workflow.util.Validatable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ActionDescriptor
extends AbstractDescriptor
implements Validatable {
    protected List conditionalResults = new ArrayList();
    protected List postFunctions = new ArrayList();
    protected List preFunctions = new ArrayList();
    protected List validators = new ArrayList();
    protected Map metaAttributes = new HashMap();
    protected RestrictionDescriptor restriction;
    protected ResultDescriptor unconditionalResult;
    protected String name;
    protected String view;
    protected boolean autoExecute = false;
    protected boolean common;
    protected boolean finish = false;

    ActionDescriptor() {
    }

    ActionDescriptor(Element action) {
        this.init(action);
    }

    public void setAutoExecute(boolean autoExecute) {
        this.autoExecute = autoExecute;
    }

    public boolean getAutoExecute() {
        return this.autoExecute;
    }

    public boolean isCommon() {
        return this.common;
    }

    public List getConditionalResults() {
        return this.conditionalResults;
    }

    public void setFinish(boolean finish) {
        this.finish = finish;
    }

    public boolean isFinish() {
        return this.finish;
    }

    public void setMetaAttributes(Map metaAttributes) {
        this.metaAttributes = metaAttributes;
    }

    public Map getMetaAttributes() {
        return this.metaAttributes;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List getPostFunctions() {
        return this.postFunctions;
    }

    public List getPreFunctions() {
        return this.preFunctions;
    }

    public void setRestriction(RestrictionDescriptor restriction) {
        this.restriction = restriction;
    }

    public RestrictionDescriptor getRestriction() {
        return this.restriction;
    }

    public void setUnconditionalResult(ResultDescriptor unconditionalResult) {
        this.unconditionalResult = unconditionalResult;
    }

    public ResultDescriptor getUnconditionalResult() {
        return this.unconditionalResult;
    }

    public List getValidators() {
        return this.validators;
    }

    public void setView(String view) {
        this.view = view;
    }

    public String getView() {
        return this.view;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.name != null) {
            sb.append(this.name);
        }
        if (this.view != null && this.view.length() > 0) {
            sb.append(" (").append(this.view).append(")");
        }
        return sb.toString();
    }

    public void validate() throws InvalidWorkflowDescriptorException {
        ValidationHelper.validate(this.preFunctions);
        ValidationHelper.validate(this.postFunctions);
        ValidationHelper.validate(this.validators);
        ValidationHelper.validate(this.conditionalResults);
        if (this.conditionalResults.size() > 0 && this.unconditionalResult == null) {
            throw new InvalidWorkflowDescriptorException("Action " + this.name + " has conditional results but no fallback unconditional result");
        }
        if (this.restriction != null) {
            this.restriction.validate();
        }
        if (this.unconditionalResult != null) {
            this.unconditionalResult.validate();
        }
    }

    public void writeXML(PrintWriter out, int indent) {
        int i;
        FunctionDescriptor function;
        XMLUtil.printIndent(out, indent++);
        StringBuffer buf = new StringBuffer("<action id=\"");
        buf.append(this.getId());
        buf.append("\"");
        if (this.name != null && this.name.length() > 0) {
            buf.append(" name=\"");
            buf.append(XMLUtil.encode(this.name));
            buf.append("\"");
        }
        if (this.view != null && this.view.length() > 0) {
            buf.append(" view=\"");
            buf.append(XMLUtil.encode(this.view));
            buf.append("\"");
        }
        if (this.finish) {
            buf.append(" finish=\"true\"");
        }
        if (this.autoExecute) {
            buf.append(" auto=\"true\"");
        }
        buf.append(">");
        out.println(buf.toString());
        Iterator iter = this.metaAttributes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            XMLUtil.printIndent(out, indent);
            out.print("<meta name=\"");
            out.print(XMLUtil.encode(entry.getKey()));
            out.print("\">");
            out.print(XMLUtil.encode(entry.getValue()));
            out.println("</meta>");
        }
        if (this.restriction != null) {
            this.restriction.writeXML(out, indent);
        }
        if (this.validators.size() > 0) {
            XMLUtil.printIndent(out, indent++);
            out.println("<validators>");
            for (int i2 = 0; i2 < this.validators.size(); ++i2) {
                ValidatorDescriptor validator = (ValidatorDescriptor)this.validators.get(i2);
                validator.writeXML(out, indent);
            }
            XMLUtil.printIndent(out, --indent);
            out.println("</validators>");
        }
        if (this.preFunctions.size() > 0) {
            XMLUtil.printIndent(out, indent++);
            out.println("<pre-functions>");
            for (int i3 = 0; i3 < this.preFunctions.size(); ++i3) {
                function = (FunctionDescriptor)this.preFunctions.get(i3);
                function.writeXML(out, indent);
            }
            XMLUtil.printIndent(out, --indent);
            out.println("</pre-functions>");
        }
        XMLUtil.printIndent(out, indent++);
        out.println("<results>");
        for (i = 0; i < this.conditionalResults.size(); ++i) {
            ConditionalResultDescriptor result = (ConditionalResultDescriptor)this.conditionalResults.get(i);
            result.writeXML(out, indent);
        }
        if (this.unconditionalResult != null) {
            this.unconditionalResult.writeXML(out, indent);
        }
        XMLUtil.printIndent(out, --indent);
        out.println("</results>");
        if (this.postFunctions.size() > 0) {
            XMLUtil.printIndent(out, indent++);
            out.println("<post-functions>");
            for (i = 0; i < this.postFunctions.size(); ++i) {
                function = (FunctionDescriptor)this.postFunctions.get(i);
                function.writeXML(out, indent);
            }
            XMLUtil.printIndent(out, --indent);
            out.println("</post-functions>");
        }
        XMLUtil.printIndent(out, --indent);
        out.println("</action>");
    }

    protected void init(Element action) {
        Element restrictElement;
        Element post;
        Element pre;
        try {
            this.setId(Integer.parseInt(action.getAttribute("id")));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid action id value '" + action.getAttribute("id") + "'");
        }
        this.name = action.getAttribute("name");
        this.view = action.getAttribute("view");
        this.autoExecute = "true".equalsIgnoreCase(action.getAttribute("auto"));
        this.finish = "true".equalsIgnoreCase(action.getAttribute("finish"));
        NodeList children = action.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals("meta")) continue;
            Element meta = (Element)child;
            String value = XMLUtil.getText(meta);
            this.metaAttributes.put(meta.getAttribute("name"), value);
        }
        Element v = XMLUtil.getChildElement(action, "validators");
        if (v != null) {
            List validators = XMLUtil.getChildElements(v, "validator");
            for (int k = 0; k < validators.size(); ++k) {
                Element validator = (Element)validators.get(k);
                ValidatorDescriptor validatorDescriptor = DescriptorFactory.getFactory().createValidatorDescriptor(validator);
                validatorDescriptor.setParent(this);
                this.validators.add(validatorDescriptor);
            }
        }
        if ((pre = XMLUtil.getChildElement(action, "pre-functions")) != null) {
            List preFunctions = XMLUtil.getChildElements(pre, "function");
            for (int k = 0; k < preFunctions.size(); ++k) {
                Element preFunction = (Element)preFunctions.get(k);
                FunctionDescriptor functionDescriptor = DescriptorFactory.getFactory().createFunctionDescriptor(preFunction);
                functionDescriptor.setParent(this);
                this.preFunctions.add(functionDescriptor);
            }
        }
        Element resultsElememt = XMLUtil.getChildElement(action, "results");
        List results = XMLUtil.getChildElements(resultsElememt, "result");
        for (int k = 0; k < results.size(); ++k) {
            Element result = (Element)results.get(k);
            ConditionalResultDescriptor conditionalResultDescriptor = new ConditionalResultDescriptor(result);
            conditionalResultDescriptor.setParent(this);
            this.conditionalResults.add(conditionalResultDescriptor);
        }
        Element unconditionalResult = XMLUtil.getChildElement(resultsElememt, "unconditional-result");
        if (unconditionalResult != null) {
            this.unconditionalResult = DescriptorFactory.getFactory().createResultDescriptor(unconditionalResult);
            this.unconditionalResult.setParent(this);
        }
        if ((post = XMLUtil.getChildElement(action, "post-functions")) != null) {
            List postFunctions = XMLUtil.getChildElements(post, "function");
            for (int k = 0; k < postFunctions.size(); ++k) {
                Element postFunction = (Element)postFunctions.get(k);
                FunctionDescriptor functionDescriptor = DescriptorFactory.getFactory().createFunctionDescriptor(postFunction);
                functionDescriptor.setParent(this);
                this.postFunctions.add(functionDescriptor);
            }
        }
        if ((restrictElement = XMLUtil.getChildElement(action, "restrict-to")) != null) {
            this.restriction = new RestrictionDescriptor(restrictElement);
            if (this.restriction.getConditionsDescriptor() == null) {
                this.restriction = null;
            } else {
                this.restriction.setParent(this);
            }
        }
    }

    void setCommon(boolean common) {
        this.common = common;
    }
}

