/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.loader;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtil {
    public static Element getChildElement(Element parent, String childName) {
        NodeList children = parent.getChildNodes();
        int size = children.getLength();
        for (int i = 0; i < size; ++i) {
            Element element;
            Node node = children.item(i);
            if (node.getNodeType() != 1 || !childName.equals((element = (Element)node).getNodeName())) continue;
            return element;
        }
        return null;
    }

    public static List getChildElements(Element parent, String childName) {
        NodeList children = parent.getChildNodes();
        ArrayList<Element> list = new ArrayList<Element>();
        int size = children.getLength();
        for (int i = 0; i < size; ++i) {
            Element element;
            Node node = children.item(i);
            if (node.getNodeType() != 1 || !childName.equals((element = (Element)node).getNodeName())) continue;
            list.add(element);
        }
        return list;
    }

    public static String getChildText(Element parent, String childName) {
        Element child = XMLUtil.getChildElement(parent, childName);
        if (child == null) {
            return null;
        }
        return XMLUtil.getText(child);
    }

    public static String getText(Element node) {
        StringBuffer sb = new StringBuffer();
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            switch (child.getNodeType()) {
                case 3: 
                case 4: {
                    sb.append(child.getNodeValue());
                }
            }
        }
        return sb.toString();
    }

    public static String encode(Object string) {
        if (string == null) {
            return "";
        }
        char[] chars = string.toString().toCharArray();
        StringBuffer out = new StringBuffer();
        block6: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '&': {
                    out.append("&amp;");
                    continue block6;
                }
                case '<': {
                    out.append("&lt;");
                    continue block6;
                }
                case '>': {
                    out.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    out.append("&quot;");
                    continue block6;
                }
                default: {
                    out.append(chars[i]);
                }
            }
        }
        return out.toString();
    }

    public static void printIndent(PrintWriter out, int indent) {
        for (int i = 0; i < indent; ++i) {
            out.print("  ");
        }
    }
}

