/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.util;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.FunctionProvider;
import com.opensymphony.workflow.spi.WorkflowEntry;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMSMessage
implements FunctionProvider {
    private static final Log log = LogFactory.getLog((Class)(class$com$opensymphony$workflow$util$JMSMessage == null ? (class$com$opensymphony$workflow$util$JMSMessage = JMSMessage.class$("com.opensymphony.workflow.util.JMSMessage")) : class$com$opensymphony$workflow$util$JMSMessage));
    static /* synthetic */ Class class$com$opensymphony$workflow$util$JMSMessage;

    public void execute(Map transientVars, Map args, PropertySet ps) {
        WorkflowEntry entry = (WorkflowEntry)transientVars.get("entry");
        try {
            Hashtable env = new Hashtable(args);
            InitialContext initialContext = new InitialContext(env);
            if (args.containsKey("queue-factory-location")) {
                QueueConnectionFactory queueFactory = (QueueConnectionFactory)initialContext.lookup((String)args.get("queue-factory-location"));
                QueueConnection conn = queueFactory.createQueueConnection();
                conn.start();
                QueueSession queueSession = conn.createQueueSession(false, 1);
                Queue queue = (Queue)initialContext.lookup((String)args.get("queue-location"));
                QueueSender sender = queueSession.createSender(queue);
                TextMessage message = queueSession.createTextMessage();
                this.populateMessage(message, entry, args);
                sender.send((Message)message);
            } else if (args.containsKey("topic-factory-location")) {
                TopicConnectionFactory topicFactory = (TopicConnectionFactory)initialContext.lookup((String)args.get("topic-factory-location"));
                TopicConnection conn = topicFactory.createTopicConnection();
                conn.start();
                TopicSession topicSession = conn.createTopicSession(false, 1);
                Topic topic = (Topic)initialContext.lookup((String)args.get("topic-location"));
                TopicPublisher publisher = topicSession.createPublisher(topic);
                TextMessage message = topicSession.createTextMessage();
                this.populateMessage(message, entry, args);
                publisher.publish((Message)message);
            }
        }
        catch (Exception ex) {
            log.error((Object)"Error sending JMS message", (Throwable)ex);
        }
    }

    private void populateMessage(TextMessage message, WorkflowEntry entry, Map properties) throws JMSException {
        message.setText((String)properties.get("text"));
        message.setLongProperty("workflowEntry", entry.getId());
        Iterator iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry mapEntry = iterator.next();
            if ("text".equals(mapEntry.getKey())) continue;
            message.setObjectProperty((String)mapEntry.getKey(), mapEntry.getValue());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

