/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.util;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.InvalidInputException;
import com.opensymphony.workflow.Validator;
import com.opensymphony.workflow.WorkflowContext;
import com.opensymphony.workflow.WorkflowException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import webwork.action.Action;
import webwork.action.ActionContext;
import webwork.dispatcher.ActionResult;
import webwork.dispatcher.GenericDispatcher;

public class WebWorkValidator
implements Validator {
    public void validate(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        final WorkflowContext wfContext = (WorkflowContext)transientVars.get("context");
        String actionName = (String)args.get("action.name");
        GenericDispatcher gd = new GenericDispatcher(actionName);
        gd.prepareContext();
        ActionContext.setPrincipal((Principal)new Principal(){

            public String getName() {
                return wfContext.getCaller();
            }
        });
        ActionContext.setApplication((Map)args);
        ActionContext.setSession((Map)ps.getProperties(""));
        ActionContext.setLocale((Locale)Locale.getDefault());
        ActionContext.setParameters(Collections.unmodifiableMap(transientVars));
        boolean hasErrors = false;
        InvalidInputException iie = new InvalidInputException();
        try {
            gd.executeAction();
            ActionResult ar = gd.finish();
            gd.finalizeContext();
            List actions = ar.getActions();
            Iterator iterator = actions.iterator();
            while (iterator.hasNext()) {
                Action action = (Action)iterator.next();
                List errorMessages = this.getErrorMessages(action);
                Iterator iterator2 = errorMessages.iterator();
                while (iterator2.hasNext()) {
                    String error = (String)iterator2.next();
                    iie.addError(error);
                    hasErrors = true;
                }
                Map errors = this.getErrors(action);
                Iterator iterator22 = errors.entrySet().iterator();
                while (iterator22.hasNext()) {
                    Map.Entry entry = iterator22.next();
                    String error = (String)entry.getKey();
                    String message = (String)entry.getValue();
                    iie.addError(error, message);
                    hasErrors = true;
                }
            }
        }
        catch (Exception e) {
            throw new WorkflowException("Could not execute action " + actionName, e);
        }
        if (hasErrors) {
            throw iie;
        }
    }

    private List getErrorMessages(Action action) {
        try {
            Method m = action.getClass().getMethod("getErrorMessages", new Class[0]);
            return (List)m.invoke((Object)action, new Object[0]);
        }
        catch (Throwable t) {
            return Collections.EMPTY_LIST;
        }
    }

    private Map getErrors(Action action) {
        try {
            Method m = action.getClass().getMethod("getErrors", new Class[0]);
            return (Map)m.invoke((Object)action, new Object[0]);
        }
        catch (Throwable t) {
            return Collections.EMPTY_MAP;
        }
    }
}

