/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.util.bsf;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.Condition;
import com.opensymphony.workflow.WorkflowContext;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.spi.WorkflowEntry;
import java.util.Map;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;

public class BSFCondition
implements Condition {
    public boolean passesCondition(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        String language = (String)args.get("language");
        String source = (String)args.get("source");
        int row = TextUtils.parseInt((String)((String)args.get("row")));
        int col = TextUtils.parseInt((String)((String)args.get("col")));
        String script = (String)args.get("script");
        WorkflowContext context = (WorkflowContext)transientVars.get("context");
        WorkflowEntry entry = (WorkflowEntry)transientVars.get("entry");
        BSFManager mgr = new BSFManager();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            mgr.setClassLoader(loader);
        }
        mgr.registerBean("entry", (Object)entry);
        mgr.registerBean("context", (Object)context);
        mgr.registerBean("transientVars", (Object)transientVars);
        mgr.registerBean("propertySet", (Object)ps);
        mgr.registerBean("jn", transientVars.get("jn"));
        try {
            BSFEngine engine = mgr.loadScriptingEngine(language);
            Object o = engine.eval(source, row, col, (Object)script);
            if (o == null) {
                return false;
            }
            return TextUtils.parseBoolean((String)o.toString());
        }
        catch (BSFException e) {
            String message = "Could not execute BSF script";
            throw new WorkflowException(message, e);
        }
    }
}

