/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.propertyset.file;

import com.opensymphony.module.propertyset.memory.MemoryPropertySet;
import com.opensymphony.util.Data;
import com.opensymphony.util.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class PropertiesFilePropertySet
extends MemoryPropertySet {
    protected static Log log = LogFactory.getLog((Class)(class$com$opensymphony$module$propertyset$file$PropertiesFilePropertySet == null ? (class$com$opensymphony$module$propertyset$file$PropertiesFilePropertySet = PropertiesFilePropertySet.class$("com.opensymphony.module.propertyset.file.PropertiesFilePropertySet")) : class$com$opensymphony$module$propertyset$file$PropertiesFilePropertySet));
    private File file;
    static /* synthetic */ Class class$com$opensymphony$module$propertyset$file$PropertiesFilePropertySet;

    public void flush() throws IOException {
        Iterator iter = this.getMap().entrySet().iterator();
        Properties p = new Properties();
        while (iter.hasNext()) {
            String value;
            Map.Entry entry = iter.next();
            String name = (String)entry.getKey();
            MemoryPropertySet.ValueEntry valueEntry = (MemoryPropertySet.ValueEntry)entry.getValue();
            switch (valueEntry.getType()) {
                case 9: {
                    value = XMLUtils.print((Document)((Document)valueEntry.getValue()));
                    break;
                }
                case 8: 
                case 11: {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ObjectOutputStream os = new ObjectOutputStream(bos);
                    os.writeObject(valueEntry.getValue());
                    byte[] data = bos.toByteArray();
                    value = new BASE64Encoder().encode(data);
                    break;
                }
                case 7: {
                    value = DateFormat.getDateTimeInstance().format((Date)valueEntry.getValue());
                    break;
                }
                case 10: {
                    if (valueEntry.getValue() instanceof byte[]) {
                        value = new BASE64Encoder().encode((byte[])valueEntry.getValue());
                        break;
                    }
                    value = new BASE64Encoder().encode(((Data)valueEntry.getValue()).getBytes());
                    break;
                }
                default: {
                    value = valueEntry.getValue().toString();
                }
            }
            p.put(name + "." + valueEntry.getType(), value);
        }
        p.store(new FileOutputStream(this.file), null);
    }

    public void init(Map config, Map args) {
        super.init(config, args);
        this.file = new File((String)args.get("file"));
        if (this.file.exists()) {
            try {
                this.load();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void load() throws IOException, ClassNotFoundException {
        Properties p = new Properties();
        p.load(new FileInputStream(this.file));
        Iterator<Map.Entry<Object, Object>> iter = p.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> entry = iter.next();
            String key = (String)entry.getKey();
            int dot = key.lastIndexOf(46);
            int type = Integer.parseInt(key.substring(dot + 1));
            String name = key.substring(0, dot);
            if (log.isDebugEnabled()) {
                log.debug((Object)("key=" + key + " type=" + type + " name=" + name));
            }
            String data = (String)entry.getValue();
            Object value = null;
            switch (type) {
                case 5: 
                case 6: {
                    value = data;
                    break;
                }
                case 2: {
                    value = new Integer(data);
                    break;
                }
                case 3: {
                    value = new Long(data);
                    break;
                }
                case 4: {
                    value = new Double(data);
                    break;
                }
                case 1: {
                    value = new Boolean(data);
                    break;
                }
                case 10: {
                    value = new BASE64Decoder().decodeBuffer(data);
                    break;
                }
                case 7: {
                    try {
                        value = DateFormat.getDateTimeInstance().parse(data);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 8: 
                case 11: {
                    byte[] bytes = new BASE64Decoder().decodeBuffer(data);
                    ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                    ObjectInputStream is = new ObjectInputStream(bis);
                    value = is.readObject();
                    break;
                }
                case 9: {
                    try {
                        value = XMLUtils.parse((String)data);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                default: {
                    throw new IOException("Unsupported type " + type);
                }
            }
            this.getMap().put(name, new MemoryPropertySet.ValueEntry(type, value));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

