/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.action;

import java.beans.PropertyEditorSupport;

/**
 * This is a useful base class for JavaBeans property editors whose main purpose is to provide validation of form input
 * parameters.
 * <p/>
 * Overriding setAsText is sufficient. Do whatever validation you need and throw IllegalArgumentException if something
 * is wrong. If all is ok then set the protected attribute "value" to the converted value (may be a string).
 *
 * @author Rickard \u00D6berg (rickard@middleware-company.com)
 * @version $Revision: 1.6 $
 * @see PropertyEditorSupport
 * @see java.beans.BeanInfo
 */
public abstract class ValidationEditorSupport extends PropertyEditorSupport
{
    protected Object value;

    // Public  -------------------------------------------------------
    public void setValue(Object val)
    {
        value = val;
    }

    public String getAsText()
    {
        return value == null ? "" : value.toString();
    }

    /**
     * This method is specified in the FastPropertyEditor interface and it is implemented here for convenience
     */
    public String getAsText(Object val)
    {
        return val == null ? "" : val.toString();
    }

    public abstract void setAsText(String txt);

    public Object getValue()
    {
        return value;
    }
}