package webwork.config;

/**
 * @since 14
 * Created by rshuttleworth @ 17/02/11 5:00 PM
 */
public class WebworkConfigurationNotFoundException extends IllegalArgumentException
{
    private final Object clazz;
    private final String message;
    private final String name;

    public WebworkConfigurationNotFoundException (final Object clazz, final String message, final String name)
    {
        this.clazz = clazz;
        this.message = message;
        this.name = name;
    }

    public Throwable fillInStackTrace()
    {
        return this;
    }

    @Override
    public String getMessage() {
        return toString();
    }

    @Override
    public String toString() {
        return "WebworkConfigurationNotFoundException{" +
                "class=" + clazz +
                ", message='" + message + '\'' +
                ", name='" + name + '\'' +
                '}';
    }
}
