package webwork.dispatcher;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.servlet.*;
import java.io.IOException;

/**
 * CleanupFilter can be applied to
 *
 * @author Jason Carreira Date: May 27, 2004 1:27:36 PM
 */
public class CleanupFilter implements Filter
{
    public static final String DO_NOT_CLEAN = "webwork.cleanupfilter";
    private static final String FILTER_ALREADY_RUN_KEY = CleanupFilter.class.getName() + "_run";
    private static Log LOG = LogFactory.getLog(ServletDispatcher.class);

    public void destroy()
    {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain)
            throws IOException, ServletException
    {
        // ensure the filter is only run one time.  This prevents problems on servers such as Orion
        // which run filters on includes also.
        if (servletRequest.getAttribute(FILTER_ALREADY_RUN_KEY) != null)
        {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        else
        {
            servletRequest.setAttribute(FILTER_ALREADY_RUN_KEY, new Boolean(true));
            servletRequest.setAttribute(DO_NOT_CLEAN, Boolean.TRUE);
            filterChain.doFilter(servletRequest, servletResponse);
            GenericDispatcher gd = (GenericDispatcher) servletRequest.getAttribute(ServletDispatcher.GENERIC_DISPATCHER_FOR_CLEANUP);
            if (gd != null)
            {
                LOG.debug("Cleaning up generic dispatcher.");
                gd.finalizeContext();
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException
    {
    }
}
