/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */

package webwork.examples;


import webwork.action.ActionSupport;
import webwork.action.PrepareAction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <description>
 *
 * @author Onyeje Bose (digi9ten@yahoo.com)
 * @version $Revision: 1.4 $
 * @see <related>
 */


public class CascadingSelectTest
        extends ActionSupport
        implements PrepareAction
{
    public void prepare()
    {
        emptyList.add("Select a Valid Company...");

        for (int i = 0; i < NUM; i++)
        {
            String companyKey = Integer.toString(i);
            String companyVal = "Company " + i;
            companies.put(companyKey, companyVal);

            Map tmpMap = new HashMap(NUM);

            for (int j = 0; j < NUM * NUM; j += NUM)
            {
                String vendKey = Integer.toString(j);
                String vendVal = "Vendor " + j + " of Company " + i;
                tmpMap.put(vendKey, vendVal);
            }

            vendors.put(companyKey, tmpMap);
        }
    }

    public Map getCompanies()
    {
        return companies;
    }

    public Map getVendors()
    {
        return vendors;
    }

    public List getEmptyList()
    {
        return emptyList;
    }

    // Constants -----------------------------------------------------
    final static int NUM = 5;

    // Attributes/Propeties -----------------------------------------------------
    Map companies = new HashMap(NUM);
    Map vendors = new HashMap(NUM);
    List emptyList = new ArrayList(1);
}




