/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples;

import webwork.action.ActionSupport;

import java.util.Map;
import java.util.TreeMap;

/**
 * A map of countries in a couple of continents
 *
 * @author Rickard \u00D6berg (<email>)
 * @version $Revision: 1.4 $
 * @see <related>
 */
public class CountryMap
        extends ActionSupport
{
    // Attributes ----------------------------------------------------
    Map countries;

    // Public --------------------------------------------------------
    public Map getCountries()
    {
        return countries;
    }

    // Action implementation -----------------------------------------
    protected String doExecute()
            throws Exception
    {
        countries = new TreeMap();

        Map continent = new TreeMap();
        continent.put("sv", "Sweden");
        continent.put("uk", "United Kingdom");
        continent.put("ge", "Germany");
        countries.put("Europe", continent);

        continent = new TreeMap();
        continent.put("ch", "China");
        continent.put("in", "India");
        continent.put("ru", "Russia");
        countries.put("Asia", continent);

        continent = new TreeMap();
        continent.put("us", "USA");
        continent.put("ca", "Canada");
        countries.put("North America", continent);

        return SUCCESS;
    }
}
