/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples;

import webwork.action.ActionSupport;
import webwork.action.CommandDriven;
import webwork.action.ActionContext;
import webwork.multipart.MultiPartRequestWrapper;

import java.util.Enumeration;
import java.util.List;
import java.util.ArrayList;

/**
 * Multi-part action
 *
 * @author Matt Baldree (matt@smallleap.com)
 * @version $Revision: 1.3 $
 */
public class FileUploadTest
        extends ActionSupport
{
    private String[] severityList = { "Trivial", "Minor", "Major", "Critical" };
    private String description;
    private String severity;
    private List uploadedFiles = new ArrayList();

    // Public --------------------------------------------------------
    public String[] getSeverityList()
    {
        return severityList;
    }

    public String getSeverity()
    {
        return severity;
    }

    public void setSeverity(String severity)
    {
        this.severity = severity;
    }

    public String getDescription()
    {
        return description;
    }

    public List getUploadedFiles()
    {
        return uploadedFiles;
    }

    public void setDescription(String description)
    {
        if ("".equals(description))
        {
            throw new IllegalArgumentException("Description is required.");
        }
        this.description = description;
    }

    // Public --------------------------------------------------------

    public String doExecute()
            throws Exception
    {
        log.debug("description=" + description);
        log.debug("severity=" + severity);

        try
        {
            Enumeration names = ActionContext.getMultiPartRequest().getFileNames();
            while (names.hasMoreElements())
            {
                String file = (String) names.nextElement();
                log.info("Received " + ActionContext.getMultiPartRequest().getFile(file));
                uploadedFiles.add(ActionContext.getMultiPartRequest().getFilesystemName(file));
            }
        }
        catch (Exception e)
        {
        }
        return SUCCESS;
    }

}
