/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples;

import org.apache.commons.logging.*;
import webwork.action.ActionSupport;
import webwork.action.ParameterAware;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/**
 * Simple test action.
 *
 * @author Rickard \u00D6berg (rickard@middleware-company.com)
 * @version $Revision: 1.13 $
 * @see <related>
 */
public class Test extends ActionSupport implements ParameterAware
{
    // Constants -----------------------------------------------------

    // Attributes ----------------------------------------------------
    String name = "HelloWorld";
    String foo;
    ArrayList list;
    Properties settings = new Properties();
    Map params;
    Person person = new Person();
    int[] ints = new int[] { 0, 1, 2, 3 };
    Integer[] integers = new Integer[] { new Integer(0), new Integer(1), new Integer(2), new Integer(3) };
    long[] longs = new long[] { 0, 1, 2, 3 };
    Long[] longObjects = new Long[] { new Long(0), new Long(1), new Long(2), new Long(3) };

    // Static --------------------------------------------------------

    // Constructors --------------------------------------------------

    // Public --------------------------------------------------------

    public String getName()
    {
        return name;
    }

    public List getPeople()
    {
        return list;
    }

    public Map getSettings()
    {
        return settings;
    }

    public Map getParameters()
    {
        return params;
    }

    public Person getPerson()
    {
        return person;
    }

    public Person getPerson(String name)
    {
        return new Person(name, null);
    }

    public Test getTest()
    {
        return this;
    }

    public Boolean getBool(String b)
    {
        return new Boolean(b);
    }

    public String getSecond(String one, String two)
    {
        return two;
    }

    public boolean isOk()
    {
        return true;
    }

    public boolean getStringsEqual(String one, String two)
    {
        return one.equals(two);
    }

    public Integer getInteger(int i)
    {
        return new Integer(i);
    }

    public void setFoo(String aValue)
    {
        foo = aValue;
    }

    public String getFoo()
    {
        return foo;
    }

    public boolean[] getBools()
    {
        boolean[] b = new boolean[] { true, false, false, true };
        return b;
    }

    public int[] getInts()
    {
        return ints;
    }

    public Integer[] getIntegers()
    {
        return integers;
    }

    public long[] getLongs()
    {
        return longs;
    }

    public Long[] getLongObjects()
    {
        return longObjects;
    }

    public String concat(String s1, String s2)
    {
        return s1 + s2;
    }

    public String concat(String s1, String s2, String s3)
    {
        return s1 + s2 + s3;
    }

    public String getSameString(String s)
    {
        return s;
    }

    // ParameterAware implementation ---------------------------------
    public void setParameters(Map parameters)
    {
        this.params = parameters;
    }

    // Action implementation -----------------------------------------
    protected String doExecute() throws Exception
    {
        list = new ArrayList();
        list.add(new Person());
        list.add(new Person("Maurice C. Parker", "maurice@vineyardenterprise.com"));
        list.add(new Person("Dick Zetterberg", "dick@nospam.se"));

        settings.put("foo", "bar");
        settings.put("black", "white");

        return SUCCESS;
    }

    /**
     * Test of CommandDriven interface
     */
    public String doFoo()
    {
        LogFactory.getLog(this.getClass()).debug("Foo command executed");
        return SUCCESS;
    }

}
