/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples.bank;

import webwork.action.ValidationEditorSupport;

/**
 * This code is an adaptation of the Struts example from the JavaWorld article by Thor Kristmundsson.
 * http://www.javaworld.com/javaworld/jw-12-2000/jw-1201-struts_p.html
 */
public class NameEditor
        extends ValidationEditorSupport
{
    public void setAsText(String txt)
    {
        // Validate name
        if (txt.length() > 30)
        {
            throw new IllegalArgumentException("Maximum of 30 alphabetic characters");
        }

        if (txt.length() == 0)
        {
            throw new IllegalArgumentException("Name must be specified");
        }

        setValue(txt);
    }
}