/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples.events;

import webwork.action.ActionSupport;
import webwork.action.SessionAware;

import java.util.Map;

/**
 * This code is an adaptation of the EventHandler example from the Rocks homepage by Christian Cryder
 * http://xmlc.enhydra.org/EventHandler/
 */
public class Logout
        extends ActionSupport
        implements SessionAware
{
    // Attributes ----------------------------------------------------
    Map session;

    // SessionAware implementation ------------------------------------
    public void setSession(Map session)
    {
        this.session = session;
    }

    // Action implementation ----------------------------------------
    protected String doExecute()
    {
        // Logout
        session.remove("login");
        session.remove("count");

        // Show result
        return SUCCESS;
    }
}
