/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples.helloworld.applet;

import webwork.action.client.ActionResult;
import webwork.action.client.ClientDispatcher;
import webwork.examples.helloworld.HelloWorld;

import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.net.URL;

/**
 * Applet for the HelloWorld example that showcases the use of the ClientDispatcher to access server-side
 * functionality.
 *
 * @author Rickard \u00D6berg (rickard@middleware-company.com)
 */
public class HelloApplet
        extends Applet
{
    // Attributes ----------------------------------------------------
    ClientDispatcher dispatcher;
    Label responseLabel;
    HelloWorld action = new HelloWorld();

    // Public --------------------------------------------------------
    public void init()
    {
        // Init action dispatcher
        try
        {
            dispatcher = new ClientDispatcher(this, "/webwork");
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }

        // Init action
        action.setPhrase("Hello");
        action.setName("Worlds");

        // Init UI
        final Container pane = this;
        final CardLayout cardLayout = new CardLayout();
        pane.setLayout(cardLayout);

        // Login
        Container login = new Panel(new BorderLayout());
        pane.add("login", login);
        login.add("Center", new Label("Enter your name:"));
        final TextField nameInput = new TextField();
        login.add("South", nameInput);
        nameInput.addActionListener(new ActionListener()
        {
            public void actionPerformed(ActionEvent e)
            {
                try
                {
                    action.setName(nameInput.getText());
                    nameInput.setText("");

                    // Execute action
                    getGreeting();
                }
                catch (Exception ex)
                {
                    responseLabel.setText(ex.toString());
                    ex.printStackTrace();
                }
                // Switch to response
                cardLayout.show(pane, "response");
                validate();
            }
        });

        // Response pane
        Container response = new Panel(new BorderLayout());
        pane.add("response", response);
        responseLabel = new Label();
        response.add("Center", responseLabel);
        final Button responseOk = new Button("Ok");
        response.add("South", responseOk);
        responseOk.addActionListener(new ActionListener()
        {
            public void actionPerformed(ActionEvent e)
            {
                cardLayout.show(pane, "greeting");
                validate();
            }
        });

        // Greeting pane
        Container greeting = new Panel(new BorderLayout());
        pane.add("greeting", greeting);
        greeting.add("Center", new Label("Enter greeting phrase:"));
        final TextField greetingInput = new TextField();
        greeting.add("South", greetingInput);
        greetingInput.addActionListener(new ActionListener()
        {
            public void actionPerformed(ActionEvent e)
            {
                try
                {
                    action.setPhrase(greetingInput.getText());
                    greetingInput.setText("");

                    // Execute action
                    getGreeting();
                }
                catch (Exception ex)
                {
                    responseLabel.setText(ex.toString());
                    ex.printStackTrace();
                }
                // Switch to response
                cardLayout.show(pane, "response");
                validate();
            }
        });
    }

    // Protected -----------------------------------------------------
    protected void getGreeting()
            throws Exception
    {
        ActionResult result = dispatcher.execute(action);
        action = (HelloWorld) result.getAction();

        responseLabel.setText(action.getGreeting());
    }
}
