/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples.i18n;

import webwork.action.ActionSupport;
import webwork.action.SessionAware;

import java.util.Locale;
import java.util.Map;

/**
 * This code is an adaptation of the I18N example from the JavaWorld article by Govind Seshadri.
 * http://www.javaworld.com/javaworld/jw-03-2000/jw-03-ssj-jsp_p.html
 */
public class Shop
        extends ActionSupport
        implements SessionAware
{
    // Attributes ---------------------------------------------------
    protected Map session;
    protected Map application;

    // SessionAware implementation -----------------------------------
    public void setSession(Map session)
    {
        this.session = session;
    }

    // Public  -------------------------------------------------------
    public Cart getCart()
    {
        Cart cart = (Cart) session.get("cart");
        if (cart == null)
        {
            cart = new Cart();
            session.put("cart", cart);
        }

        return cart;
    }

    // ActionSupport overrides ---------------------------------------
    public Locale getLocale()
    {
        Locale l = (Locale) session.get("locale");
        return (l == null) ? Locale.getDefault() : l;
    }

}