/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples.jdom;

import org.apache.commons.logging.*;
import webwork.action.ActionSupport;
import webwork.action.ParameterAware;
import webwork.examples.Person;

import org.jdom.*;
import org.jdom.input.SAXBuilder;
import org.jdom.input.DOMBuilder;
import org.jdom.output.*;

import java.util.*;

/**
 * Simple JDOM test.
 *
 * @author Rickard \u00D6berg (rickard@middleware-company.com)
 * @version $Revision: 1.8 $
 * @see <related>
 */
public class JDOMTest extends ActionSupport
{
    // Attributes ----------------------------------------------------

    // Public --------------------------------------------------------
    Document doc;

    public Document getDoc()
    {
        return doc;
    }

    // Action implementation -----------------------------------------
    protected String doExecute() throws Exception
    {
        SAXBuilder builder = new SAXBuilder();
        doc = builder.build(getClass().getResource("/webwork/examples/test.xml"));

        return SUCCESS;
    }

    // Protected -----------------------------------------------------
}
