/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.util;

/**
 * A bean that can be used to keep track of a counter.
 * <p/>
 * Since it is an Iterator it can be used by the iterator tag
 *
 * @author Rickard \u00D6berg (rickard@middleware-company.com)
 * @version $Revision: 1.9 $
 * @see <related>
 */
public class Counter
        implements java.util.Iterator
{
    // Attributes ----------------------------------------------------
    long first = 1;
    long current = first;
    long interval = 1;
    long last = -1;
    boolean wrap = false;

    // Public --------------------------------------------------------
    public long getNext()
    {
        long next = current;
        current += interval;
        if (wrap && current > last)
        {
            current -= (1 + last - first);
        }

        return next;
    }

    public long getPrevious()
    {
        current -= interval;
        if (wrap && current < first)
        {
            current += (last - first + 1);
        }

        return current;
    }

    public long getFirst()
    {
        return first;
    }

    public long getLast()
    {
        return last;
    }

    public long getInterval()
    {
        return interval;
    }

    public boolean isWrap()
    {
        return wrap;
    }

    public void setFirst(long first)
    {
        this.first = first;
        current = first;
    }

    public void setCurrent(long current)
    {
        this.current = current;
    }

    public void setAdd(long addition)
    {
        current += addition;
    }

    public long getCurrent()
    {
        return current;
    }

    public void setInterval(long interval)
    {
        this.interval = interval;
    }

    public void setLast(long last)
    {
        this.last = last;
    }

    public void setWrap(boolean wrap)
    {
        this.wrap = wrap;
    }

    public boolean hasNext()
    {
        return last == -1 || wrap ? true : current <= last;
    }

    public Object next()
    {
        return new Long(getNext());
    }

    public void remove()
    {
        // Do nothing
    }
}
