package webwork.util;

/**
 * Static control of whether things are cached or not.  We had problems in webwork
 * where strings such as "com.atlassian.jira.ViewIssue@34128" would be cached as
 * webwork EL.  Profiling has revealed that out of 2000ms of stack.findValue() calls,
 * then only 18ms of that was parsing the EL strings.  So you can choose to not
 * cache them.
 *
 * This class is a weasel class so that I can externalise the putting to the static cache
 * or not.  If we run with this as off for longer enough you can do away with this
 * and make Query not cache anything.
 */
public class WebworkCacheControl
{
    private static boolean cacheQueries = true;
    private static boolean cacheSimpleTests = true;


    public static boolean isCacheQueries()
    {
        return cacheQueries;
    }

    public static void setCacheQueries(boolean cacheQueries)
    {
        WebworkCacheControl.cacheQueries = cacheQueries;
    }

    public static boolean isCacheSimpleTests()
    {
        return cacheSimpleTests;
    }

    public static void setCacheSimpleTests(boolean cacheSimpleTests)
    {
        WebworkCacheControl.cacheSimpleTests = cacheSimpleTests;
    }
}
