package webwork.view.jasperreports;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

import webwork.util.MakeIterator;
import webwork.util.ValueStack;

import dori.jasper.engine.JRDataSource;
import dori.jasper.engine.JRException;
import dori.jasper.engine.JRField;

import org.apache.commons.logging.*;

public class ValueStackDataSource implements JRDataSource
{

    /**
     * Logger for this class
     */
    private static Log log = LogFactory.getLog(ValueStackDataSource.class);

    ValueStack valueStack;
    Iterator iterator;
    boolean firstTimeThrough = true;

    /**
     * Create a value stack data source on the given iterable property
     *
     * @param valueStack The value stack to base the data source on
     * @param dataSource The property to iterate over for the report
     */
    public ValueStackDataSource(ValueStack valueStack, String dataSource)
    {
        this.valueStack = valueStack;
        Object dataSourceValue = valueStack.findValue(dataSource);

        if (dataSourceValue != null)
        {
            if (MakeIterator.isIterable(dataSourceValue))
            {
                iterator = MakeIterator.convert(dataSourceValue);
            }
            else
            {
                Object[] array = new Object[1];
                array[0] = dataSourceValue;
                iterator = MakeIterator.convert(array);
            }
        }
        else
        {
            log.warn("Data source value for data source " + dataSource +
                    " was null");
        }
    }

    /**
     * Is there any more data
     *
     * @return <code>true</code> if there are more elements to iterate over and <code>false</code> otherwise
     *
     * @throws JRException if there is a problem determining whether there is more data
     */
    public boolean next() throws JRException
    {
        if (firstTimeThrough)
        {
            firstTimeThrough = false;
        }
        else
        {
            valueStack.popValue();
        }

        if ((iterator != null) && (iterator.hasNext()))
        {
            valueStack.pushValue(iterator.next());
            log.debug("Pushed next value: " + valueStack.findValue("."));
            return true;
        }
        else
        {
            log.debug("No more values");
            return false;
        }
    }

    /**
     * Get the value of a given field
     *
     * @param field The field to get the value for. The expression language to get the value of the field is either
     *              taken from the description property or from the name of the field if the description is
     *              <code>null</code>.
     *
     * @return an <code>Object</code> containing the field value or a new <code>ValueStackDataSource</code> object if
     *         the field value evaluates to an object that can be iterated over.
     *
     * @throws JRException if there is a problem obtaining the value
     */
    public Object getFieldValue(JRField field) throws JRException
    {
        //TODO: move the code to return a ValueStackDataSource to a seperate
        //      method when and if the JRDataSource interface is updated to support
        //      this.
        String expression = field.getDescription();
        if (expression == null)
        {
            //Description is optional so use the field name as a default
            expression = field.getName();
        }

        Object value = valueStack.findValue(expression);

        log.debug("field: " + field.getName() + "/" + value);
        if (MakeIterator.isIterable(value))
        {
            //                return new ValueStackDataSource(this.valueStack, field.getName());
            return new ValueStackDataSource(this.valueStack, expression);
        }
        else
        {
            return value;
        }
    }

}
