/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.taglib.vui;

import org.apache.commons.logging.*;
import webwork.config.Configuration;
import webwork.util.ContainUtil;
import webwork.view.taglib.IncludeTag;
import webwork.view.taglib.ParamTag;
import webwork.view.taglib.WebWorkBodyTagSupport;

import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import java.util.HashMap;
import java.util.Map;
import java.io.IOException;

/**
 * Voice UI for grammar tag
 *
 * @author Jeff Haynie (jhaynie@vocalocity.net)
 * @version $Revision: 1.2 $
 */
public class GrammarTag
        extends AbstractVUITag
{
    // Attributes ----------------------------------------------------
    protected static Log log = LogFactory.getLog(GrammarTag.class);
    protected String nameAttr;
    protected String langAttr;
    protected String modelAttr;
    protected String modeAttr;
    protected String weightAttr;

    // Public --------------------------------------------------------

    public String getHeaderTemplate()
    {
        return "grammar-header.jsp";
    }

    public String getFooterTemplate()
    {
        return "grammar-footer.jsp";
    }

    public void setName(String aName)
    {
        nameAttr = aName;
    }

    public String getName()
    {
        return nameAttr;
    }

    public void setLang(String aName)
    {
        langAttr = aName;
    }

    public String getLang()
    {
        return langAttr;
    }

    public void setModel(String aName)
    {
        modelAttr = aName;
    }

    public String getModel()
    {
        return modelAttr;
    }

    public void setMode(String aName)
    {
        modeAttr = aName;
    }

    public String getMode()
    {
        return modeAttr;
    }

    public void setWeight(String aName)
    {
        weightAttr = aName;
    }

    public String getWeight()
    {
        return weightAttr;
    }

    protected void initializeAttributes()
    {
        getSetParameter(nameAttr, "name");
        getSetParameter(langAttr, "lang");
        getSetParameter(modelAttr, "model");
        getSetParameter(modeAttr, "mode");
        getSetParameter(weightAttr, "weight");
    }
}
