/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.xslt.SAXAdapter;

import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CollectionWalker extends AbstractWalker
{
    public void doWalk(XMLWalker rootWalker, ContentHandler contentHandler,
            Object value, String attributeName, List walkedInstances) throws SAXException
    {
        Collection cole = (Collection) value;
        contentHandler.startElement("", attributeName, "", EMPTY_ATTRS);
        for (Iterator colIter = cole.iterator(); colIter.hasNext();)
        {
            Object obj = (Object) colIter.next();
            rootWalker.walk(contentHandler, obj, "item", walkedInstances);
        }
        contentHandler.endElement("", attributeName, "");
    }

    public Class getWalkedType()
    {
        return Collection.class;
    }
}
