/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.xslt.SAXAdapter;

import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

import java.util.List;

public class ToStringWalker extends AbstractWalker
{
    public void doWalk(XMLWalker rootWalker, ContentHandler contentHandler, Object value,
            String attributeName, List walkedInstances) throws SAXException
    {
        contentHandler.startElement("", attributeName, "", EMPTY_ATTRS);
        contentHandler.characters(value.toString().toCharArray(), 0, value.toString().length());
        contentHandler.endElement("", attributeName, "");
    }

    public final Class getWalkedType()
    {
        return String.class;
    }
}
