/*
 * Decompiled with CFR 0.152.
 */
package webwork.dispatcher;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webwork.action.Action;
import webwork.action.ActionContext;
import webwork.action.CleanupAware;
import webwork.action.factory.ActionFactory;
import webwork.config.Configuration;
import webwork.dispatcher.ActionResult;
import webwork.dispatcher.DefaultViewMapping;
import webwork.dispatcher.ViewActionWrapper;
import webwork.dispatcher.ViewMapping;
import webwork.interceptor.ChainedInterceptorFactory;
import webwork.interceptor.DefaultInterceptorChain;
import webwork.interceptor.Interceptor;
import webwork.util.BeanUtil;
import webwork.util.ValueStack;
import webwork.util.injection.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericDispatcher {
    protected static Log log;
    private static ViewMapping mapping;
    private boolean prepared = false;
    private Map oldContextTable;
    private ActionContext context;
    private final List<Action> actions = new ArrayList<Action>();
    private String result;
    private String actionName;
    private LazyValueHolder lazyValueHolder;
    private boolean lazy = false;
    private Object view;
    private Exception actionException;
    private int initialStackSize;
    private ActionFactory actionFactory;

    public GenericDispatcher(String actionName) {
        this.actionName = actionName;
    }

    public GenericDispatcher(String actionName, boolean lazy) {
        this.actionName = actionName;
        this.lazy = lazy;
    }

    public GenericDispatcher(String actionName, ActionFactory actionFactory) {
        this.actionName = actionName;
        this.actionFactory = actionFactory;
    }

    public ActionContext prepareContext() {
        if (ActionContext.getContext() != null) {
            this.oldContextTable = ActionContext.getContext().getTable();
        }
        this.context = new ActionContext();
        ActionContext.setContext(this.context);
        this.context.put("action.chain", this.actions);
        return this.context;
    }

    public void prepareValueStack() {
        this.initialStackSize = ActionContext.getValueStack().size();
        this.prepared = true;
    }

    public ActionContext getOldContext() {
        ActionContext oldContext = new ActionContext();
        oldContext.setTable(this.oldContextTable);
        return oldContext;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void executeAction() throws Exception {
        if (!this.prepared) {
            throw new Exception("You must prepare the dispatcher first");
        }
        Action action = this.getActionFactory().getActionImpl(this.actionName);
        if (this.lazy) {
            this.lazyValueHolder = new LazyValueHolder(action);
            ActionContext.getValueStack().pushValue(this.lazyValueHolder);
            return;
        }
        try {
            this.result = this.executeAction(action);
        }
        catch (Exception e) {
            this.actionException = e;
            return;
        }
        ActionContext.getValueStack().pushValue(action);
        if (this.result != null) {
            try {
                this.view = mapping.getView(this.actionName, this.result);
            }
            catch (Exception e) {
                this.view = null;
            }
        }
        while (this.view instanceof ViewActionWrapper) {
            ViewActionWrapper viewActionWrapper = (ViewActionWrapper)this.view;
            this.actionName = viewActionWrapper.getActionName();
            action = this.getActionFactory().getActionImpl(this.actionName);
            if (viewActionWrapper.hasParams()) {
                BeanUtil.setProperties(viewActionWrapper.getParams(), action);
            }
            try {
                this.result = this.executeAction(action);
            }
            catch (Exception e) {
                this.actionException = e;
                return;
            }
            ActionContext.getValueStack().pushValue(action);
            if (this.result == null) continue;
            try {
                this.view = mapping.getView(this.actionName, this.result);
            }
            catch (Exception e) {
                this.view = null;
            }
        }
    }

    private ActionFactory getActionFactory() {
        if (this.actionFactory == null) {
            this.actionFactory = ActionFactory.getActionFactory();
        }
        return this.actionFactory;
    }

    private String executeAction(Action action) throws Exception {
        Interceptor interceptor = ChainedInterceptorFactory.getInstance().createInterceptorFor(action);
        DefaultInterceptorChain chain = new DefaultInterceptorChain(action, interceptor);
        String result = chain.proceed();
        return result;
    }

    public ActionResult finish() {
        if (this.lazy) {
            this.lazyValueHolder.getValue();
            if (this.result != null) {
                try {
                    this.view = mapping.getView(this.actionName, this.result);
                }
                catch (Exception e) {
                    this.view = null;
                }
            }
        }
        return new ActionResult(this.result, this.view, this.actions, this.actionException);
    }

    public void finalizeContext() {
        ValueStack vs = ActionContext.getValueStack();
        int finalStackSize = vs.size();
        int count = finalStackSize - this.initialStackSize;
        for (int i = 0; i < count; ++i) {
            Object o = vs.popValue();
            if (o instanceof ValueStack.ValueHolder) {
                o = ((ValueStack.ValueHolder)o).getValue();
            }
            if (!(o instanceof CleanupAware)) continue;
            ((CleanupAware)o).cleanup();
        }
        ActionContext newContext = new ActionContext();
        newContext.setTable(this.oldContextTable);
        this.oldContextTable = null;
        ActionContext.setContext(newContext);
    }

    static {
        String mappingName;
        log = LogFactory.getLog(GenericDispatcher.class);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            mappingName = Configuration.getString("webwork.viewmapping");
        }
        catch (IllegalArgumentException e) {
            mappingName = DefaultViewMapping.class.getName();
        }
        try {
            mapping = (ViewMapping)ObjectFactory.instantiateBean(classLoader, mappingName);
        }
        catch (Exception viewMappingInstanceCreationException) {
            throw new RuntimeException("The GenericDispatcher was not able to create a ViewMapping instance of class: " + mappingName, viewMappingInstanceCreationException);
        }
    }

    public class LazyValueHolder
    implements ValueStack.ValueHolder {
        private final Action action;
        private boolean hasExecuted = false;

        public LazyValueHolder(Action action) {
            this.action = action;
        }

        public Object getValue() {
            if (!this.hasExecuted) {
                this.hasExecuted = true;
                try {
                    GenericDispatcher.this.result = GenericDispatcher.this.executeAction(this.action);
                }
                catch (Exception e) {
                    GenericDispatcher.this.actionException = e;
                    GenericDispatcher.this.result = null;
                    return null;
                }
            }
            return this.action;
        }
    }
}

