/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.action.client;

import webwork.action.Action;

import java.io.Serializable;

/**
 * Carries the action execution result from the server to the client.
 *
 * @author Rickard \u00D6berg (rickard@dreambean.com)
 */
public class ActionResult implements Serializable
{
    // Attributes ----------------------------------------------------
    Action action;
    String result;
    Exception exception;

    // Static --------------------------------------------------------
    public static long serialVersionUID = 0;

    // Constructors --------------------------------------------------
    public ActionResult(Action aAction, String aResult)
    {
        action = aAction;
        result = aResult;
    }

    // Public --------------------------------------------------------
    public Action getAction()
    {
        return action;
    }

    public void setAction(Action aAction)
    {
        action = aAction;
    }

    public Exception getException()
    {
        return exception;
    }

    public void setException(Exception aException)
    {
        exception = aException;
    }

    public String getResult()
    {
        return result;
    }

    public void setResult(String aResult)
    {
        result = aResult;
    }
}
