/*
 * Decompiled with CFR 0.152.
 */
package webwork.action.factory;

import org.apache.commons.logging.LogFactory;
import webwork.action.Action;
import webwork.action.factory.DefaultActionFactory;
import webwork.config.Configuration;
import webwork.util.ClassLoaderUtils;

public abstract class ActionFactory {
    static ActionFactory defaultActionFactory;
    static ActionFactory actionFactoryImplementation;

    public static Action getAction(String aName) throws Exception {
        return ActionFactory.getActionFactory().getActionImpl(aName);
    }

    public static ActionFactory getActionFactory() {
        return actionFactoryImplementation == null ? defaultActionFactory : actionFactoryImplementation;
    }

    public static void setActionFactory(ActionFactory aFactory) throws IllegalStateException {
        if (actionFactoryImplementation != null) {
            throw new IllegalStateException("May only set action factory implementation once");
        }
        actionFactoryImplementation = aFactory;
    }

    public abstract Action getActionImpl(String var1) throws Exception;

    public void flushCaches() {
    }

    static {
        try {
            String className = Configuration.getString("webwork.action.factory");
            try {
                defaultActionFactory = (ActionFactory)ClassLoaderUtils.loadClass(className, ActionFactory.class).newInstance();
            }
            catch (Exception e) {
                LogFactory.getLog(ActionFactory.class).error((Object)("Could not instantiate action factory " + className), (Throwable)e);
                defaultActionFactory = new DefaultActionFactory();
            }
        }
        catch (IllegalArgumentException ex) {
            LogFactory.getLog(ActionFactory.class).error((Object)"Could not instantiate configuration:", (Throwable)ex);
            defaultActionFactory = new DefaultActionFactory();
        }
    }
}

