/*
 * Decompiled with CFR 0.152.
 */
package webwork.config;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import webwork.config.AbstractConfiguration;
import webwork.config.Configuration;
import webwork.config.WebworkConfigurationNotFoundException;
import webwork.config.util.XMLConfigurationReader;
import webwork.util.ClassLoaderUtils;

public class XMLActionConfiguration
extends AbstractConfiguration {
    private XMLConfigurationReader configurationReader;
    private static final Log log = LogFactory.getLog(XMLActionConfiguration.class);
    private File file;
    private long lastModified;

    public XMLActionConfiguration(String aName) {
        URL fileUrl = ClassLoaderUtils.getResource(aName + ".xml", XMLActionConfiguration.class);
        if (fileUrl == null) {
            throw new IllegalArgumentException("No such XML resource:" + aName + ".xml");
        }
        this.file = new File(fileUrl.getFile());
        if (!this.file.exists() || !this.file.canRead()) {
            this.file = null;
        }
        this.configurationReader = this.getMappingsFromResource(fileUrl);
        if (this.file != null) {
            this.lastModified = this.file.lastModified();
        }
    }

    protected XMLConfigurationReader getMappingsFromResource(URL url) {
        try {
            Document document = this.getDocument(url);
            log.debug((Object)("Found XML view configuration " + url));
            this.resolveIncludes(url, document);
            return new XMLConfigurationReader(document.getDocumentElement(), url.toExternalForm());
        }
        catch (DOMException e) {
            log.error((Object)"DOM exception", (Throwable)e);
            throw new IllegalArgumentException("Could not load XML action configuration");
        }
    }

    private Document getDocument(URL url) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            return factory.newDocumentBuilder().parse(url.openStream());
        }
        catch (SAXException e) {
            log.error((Object)("SAX exception in " + url), (Throwable)e);
            throw new IllegalArgumentException("Could not parse XML action configuration: " + e);
        }
        catch (IOException e) {
            log.error((Object)("IO exception in " + url), (Throwable)e);
            throw new IllegalArgumentException("Could not load XML action configuration");
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Parser conf exception", (Throwable)e);
            throw new IllegalArgumentException("Could not load XML action configuration");
        }
    }

    private void resolveIncludes(URL parent, Document doc) {
        Element element;
        int i;
        NodeList includes = doc.getDocumentElement().getElementsByTagName("include");
        ArrayList<Element> elements = new ArrayList<Element>(includes.getLength());
        for (i = 0; i < includes.getLength(); ++i) {
            element = (Element)includes.item(i);
            elements.add(element);
        }
        for (i = 0; i < elements.size(); ++i) {
            element = (Element)elements.get(i);
            String path = element.getAttribute("resource");
            URL url = null;
            if (path != null && path.length() > 0) {
                url = ClassLoaderUtils.getResource(path, this.getClass());
            } else {
                path = element.getAttribute("path");
                if (path != null && path.length() > 0) {
                    if (path.charAt(0) == '/') {
                        try {
                            url = new File(path).toURL();
                        }
                        catch (MalformedURLException e) {}
                    } else {
                        try {
                            File parentFile = new File(parent.getFile());
                            if (!parentFile.canRead() || !parentFile.exists()) {
                                log.warn((Object)("parentFile '" + parent + "' cannot be resolved so ignoring specified path include '" + path + "'"));
                            }
                            url = new File(parentFile.getParentFile(), path).toURL();
                        }
                        catch (MalformedURLException e) {
                            // empty catch block
                        }
                    }
                }
            }
            if (url != null) {
                Document included = this.getDocument(url);
                this.resolveIncludes(url, included);
                DocumentFragment fragment = doc.createDocumentFragment();
                NodeList includedContents = included.getDocumentElement().getChildNodes();
                int includedSize = includedContents.getLength();
                for (int j = 0; j < includedSize; ++j) {
                    Node imported = doc.importNode(includedContents.item(j), true);
                    fragment.appendChild(imported);
                }
                element.getParentNode().replaceChild(fragment, element);
                continue;
            }
            log.warn((Object)("Included url '" + path + "' not found"));
        }
    }

    @Override
    public Object getImpl(String aName) throws IllegalArgumentException {
        Object mapping;
        boolean reloadEnabled = false;
        if (!"webwork.configuration.xml.reload".equals(aName)) {
            try {
                reloadEnabled = "true".equalsIgnoreCase(Configuration.getString("webwork.configuration.xml.reload"));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (reloadEnabled && this.file != null && this.lastModified < this.file.lastModified()) {
            this.lastModified = this.file.lastModified();
            log.debug((Object)("Reloading " + this.file));
            try {
                this.configurationReader = this.getMappingsFromResource(this.file.toURL());
            }
            catch (MalformedURLException e) {
                log.error((Object)"Something horrible happened", (Throwable)e);
            }
        }
        if ((mapping = this.configurationReader.getActionMapping(aName)) == null) {
            throw new WebworkConfigurationNotFoundException(this.getClass(), "No such view mapping", aName);
        }
        return mapping;
    }

    @Override
    public void setImpl(String aName, Object aValue) {
        throw new UnsupportedOperationException("May not update XML view mapping");
    }

    @Override
    public Iterator listImpl() {
        return this.configurationReader.getActionMappingNames().iterator();
    }
}

