/*
 * Decompiled with CFR 0.152.
 */
package webwork.view.taglib;

import com.atlassian.html.encode.HtmlEncoder;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import webwork.util.BeanUtil;
import webwork.util.URLCodec;
import webwork.view.taglib.ParamTag;
import webwork.view.taglib.WebWorkBodyTagSupport;

public class URLTag
extends WebWorkBodyTagSupport
implements ParamTag.Parametric {
    private String page;
    private String valueAttr;
    private String value;
    private final Map<String, Object> params = new LinkedHashMap<String, Object>();
    private boolean includeContext = true;
    public static final String NONE = "none";
    public static final String GET = "get";
    public static final String ALL = "all";

    @Deprecated
    public void setPage(String aName) {
        this.page = aName;
    }

    public void setValue(String aName) {
        this.valueAttr = aName;
    }

    public void setIncludeContext(boolean includeContext) {
        this.includeContext = includeContext;
    }

    @Override
    public void addParameter(String name, Object value) {
        if (value == null) {
            this.params.remove(name);
        } else {
            this.params.put(name, BeanUtil.toStringValue(value));
        }
    }

    public int doStartTag() throws JspException {
        this.value = this.resolveValue();
        this.params.clear();
        return 2;
    }

    private String resolveValue() {
        if (this.page == null && this.valueAttr != null) {
            return this.findString(this.valueAttr);
        }
        return this.page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doEndTag() throws JspException {
        try {
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            StringBuilder urlFragment = new StringBuilder();
            if (this.value != null) {
                if (this.value.startsWith("/") && this.includeContext) {
                    urlFragment.append(request.getContextPath());
                }
                urlFragment.append((CharSequence)this.urlQuoteEncode(this.value));
            }
            this.addDeclaredParameters(urlFragment);
            String result = this.htmlEscape(urlFragment.toString());
            String id = this.getId();
            if (id != null) {
                this.pageContext.setAttribute(id, (Object)result);
                this.pageContext.setAttribute(id, (Object)result, 2);
            } else {
                try {
                    this.pageContext.getOut().write(result);
                }
                catch (IOException _ioe) {
                    throw new JspException("IOError: " + _ioe.getMessage(), (Throwable)_ioe);
                }
            }
            super.doEndTag();
            int n = 6;
            return n;
        }
        finally {
            this.params.clear();
        }
    }

    private void addDeclaredParameters(StringBuilder link) {
        if (this.params != null && this.params.size() > 0) {
            if (link.toString().indexOf("?") == -1) {
                link.append('?');
            } else {
                link.append("&");
            }
            Iterator<Map.Entry<String, Object>> iter = this.params.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, Object> entry = iter.next();
                String name = entry.getKey();
                Object value = entry.getValue();
                if (value != null) {
                    if (value instanceof String) {
                        link.append(this.urlEncode(name));
                        link.append('=');
                        link.append(this.urlEncode((String)value));
                    } else {
                        String[] values = (String[])value;
                        for (int i = 0; i < values.length; ++i) {
                            String multiValue = values[i];
                            link.append(this.urlEncode(name));
                            link.append('=');
                            link.append(this.urlEncode(multiValue));
                            if (i == values.length - 1) continue;
                            link.append("&");
                        }
                    }
                }
                if (!iter.hasNext()) continue;
                link.append("&");
            }
        }
    }

    protected String htmlEscape(String value) {
        return HtmlEncoder.encode((String)value);
    }

    protected String urlEncode(String value) {
        return URLCodec.encode(value);
    }

    private StringBuilder urlQuoteEncode(String urlFragement) {
        StringBuilder sb = new StringBuilder(urlFragement.length() + 16);
        for (char c : urlFragement.toCharArray()) {
            if (c == '\"') {
                sb.append("%22");
                continue;
            }
            if (c == '\'') {
                sb.append("%27");
                continue;
            }
            sb.append(c);
        }
        return sb;
    }
}

