/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.action.factory;

import javax.servlet.ServletConfig;
import java.util.*;

/**
 * @author Rickard \u00D6berg (rickard@middleware-company.com)
 * @version $Revision: 1.7 $
 */
class ServletMap extends AbstractMap
{
    ServletConfig config;
    Set entries;

    ServletMap(ServletConfig aConfig)
    {
        this.config = aConfig;
    }

    public Set entrySet()
    {
        if (entries == null)
        {
            entries = new HashSet();

            Enumeration e = config.getInitParameterNames();
            while (e.hasMoreElements())
            {
                final String key = e.nextElement().toString();
                final Object value = config.getInitParameter(key);
                entries.add(new Map.Entry()
                {
                    public boolean equals(Object obj)
                    {
                        Map.Entry entry = (Map.Entry) obj;
                        return (key == null ?
                                entry.getKey() == null : key.equals(entry.getKey())) &&
                                (value == null ?
                                        entry.getValue() == null : value.equals(entry.getValue()));
                    }

                    public int hashCode()
                    {
                        return (key == null ? 0 : key.hashCode()) ^
                                (value == null ? 0 : value.hashCode());
                    }

                    public Object getKey()
                    {
                        return key;
                    }

                    public Object getValue()
                    {
                        return value;
                    }

                    public Object setValue(Object obj)
                    {
                        throw new UnsupportedOperationException("Can't set init parameter");
                    }
                });
            }
        }

        return entries;
    }

    public Object put(Object key, Object value)
    {
        throw new UnsupportedOperationException("Can't set init parameter");
    }

    public Object get(Object key)
    {
        return config.getInitParameter(key.toString());
    }

    public Object remove(Object key)
    {
        throw new UnsupportedOperationException("Can't remove init parameter");
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Can't clear init parameters");
    }
}
