/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.action.factory;

import javax.servlet.http.HttpSession;
import java.util.*;

/**
 * @author Rickard \u00D6berg (rickard@middleware-company.com)
 * @version $Revision: 1.11 $
 */
public class SessionMap
        extends AbstractMap
{
    HttpSession session;
    Set entries;

    public SessionMap(HttpSession s)
    {
        this.session = s;
    }

    public Set entrySet()
    {
        synchronized (session)
        {
            if (entries == null)
            {
                entries = new HashSet();

                Enumeration e = session.getAttributeNames();
                while (e.hasMoreElements())
                {
                    final String key = e.nextElement().toString();
                    final Object value = session.getAttribute(key);
                    entries.add(new Map.Entry()
                    {
                        public boolean equals(Object obj)
                        {
                            Map.Entry entry = (Map.Entry) obj;
                            return (key == null ?
                                    entry.getKey() == null : key.equals(entry.getKey())) &&
                                    (value == null ?
                                            entry.getValue() == null : value.equals(entry.getValue()));
                        }

                        public int hashCode()
                        {
                            return (key == null ? 0 : key.hashCode()) ^
                                    (value == null ? 0 : value.hashCode());
                        }

                        public Object getKey()
                        {
                            return key;
                        }

                        public Object getValue()
                        {
                            return value;
                        }

                        public Object setValue(Object obj)
                        {
                            session.setAttribute(key, obj);
                            return value;
                        }
                    });
                }
            }
        }

        return entries;
    }

    public Object put(Object key, Object value)
    {
        synchronized (session)
        {
            entries = null;
            Object originalValue = session.getAttribute(key.toString());
            session.setAttribute(key.toString(), value);
            return originalValue;
        }
    }

    public Object get(Object key)
    {
        synchronized (session)
        {
            return session.getAttribute(key.toString());
        }
    }

    public Object remove(Object key)
    {
        synchronized (session)
        {
            entries = null;

            Object value = get(key);
            session.removeAttribute(key.toString());

            return value;
        }
    }

    public void clear()
    {
        synchronized (session)
        {
            entries = null;
            session.invalidate();
        }
    }
}
