/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * A bean that takes several iterators and outputs the merge of them.
 *
 * @author Rickard \u00D6berg (rickard@middleware-company.com)
 * @version $Revision: 1.7 $
 */
public class MergeIteratorFilter
        extends IteratorFilterSupport
        implements java.util.Iterator, webwork.action.Action
{
    // Attributes ----------------------------------------------------
    List sources = new ArrayList();
    List iterators = new ArrayList();
    int idx = 0;

    // Public --------------------------------------------------------
    public void setSource(Object anIterator)
    {
        sources.add(anIterator);
    }

    // Action implementation -----------------------------------------
    public String execute()
    {
        // Make source transformations
        for (int i = 0; i < sources.size(); i++)
        {
            Object source = sources.get(i);
            iterators.add(getIterator(source));
        }

        return SUCCESS;
    }

    // Iterator implementation ---------------------------------------
    public boolean hasNext()
    {
        while (iterators.size() > 0)
        {
            if (((Iterator) iterators.get(idx)).hasNext())
            {
                return true;
            }
            else
            {
                iterators.remove(idx);
                if (iterators.size() > 0)
                {
                    idx = idx % iterators.size();
                }
            }
        }
        return false;
    }

    public Object next()
    {
        try
        {
            return ((Iterator) iterators.get(idx)).next();
        }
        finally
        {
            idx = (idx + 1) % iterators.size();
        }
    }

    public void remove()
    {
        throw new UnsupportedOperationException("Remove is not supported in MergeIteratorFilter.");
    }
}
