/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.taglib;

import javax.servlet.jsp.JspException;

/**
 * Find the specified value using the ValueStack and then push it on top of the stack. The stack is popped when the end
 * of the tag is reached.
 *
 * @author Dick Zetterberg (dick@transitor.se)
 * @version $Revision: 1.2 $
 */
public class PushTag extends WebWorkTagSupport
{
    // Attributes ----------------------------------------------------
    protected String valueAttr;

    // Public --------------------------------------------------------
    public void setValue(String inName)
    {
        valueAttr = inName;
    }

    public int doStartTag() throws JspException
    {
        // Find the value and push it onto the stack
        Object value = findValue(valueAttr);
        getStack().pushValue(value);
        return EVAL_BODY_INCLUDE;
    }

    public int doEndTag() throws JspException
    {
        // Pop the value from the stack
        getStack().popValue();
        super.doEndTag();
        return EVAL_PAGE;
    }
}
