/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.taglib.iterator;

import webwork.util.SubsetIteratorFilter;
import webwork.view.taglib.ActionTag;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;

/**
 * Instantiate a JavaBean.
 * <p/>
 * The bean may be an action, in which it is executed before used. It is lazily executed, which means that you can set
 * parameters by using the "param" tag.
 *
 * @author Rickard \u00D6berg (rickard@dreambean.com)
 * @version $Revision: 1.3 $
 */
public class SubsetIteratorTag extends ActionTag
{
    // Attributes ----------------------------------------------------
    String sourceAttr;
    String countAttr;
    String startAttr;

    // Constructor ---------------------------------------------------
    @Override
    public void setParent(final Tag t)
    {
        super.setParent(t);
        setName("'" + SubsetIteratorFilter.class.getName() + "'");
    }

    // Public --------------------------------------------------------
    public void setSource(final String aName)
    {
        sourceAttr = aName;
    }

    public void setCount(final String aCount)
    {
        countAttr = aCount;
    }

    public void setStart(final String aStart)
    {
        startAttr = aStart;
    }

    @Override
    public int doStartTag() throws JspException
    {
        super.doStartTag();

        // Pop holder temporarily while we resolve names
        final Object holder = getStack().popValue();

        if (sourceAttr == null)
        {
            ((SubsetIteratorFilter) bean).setSource(findValue("."));
        }
        else
        {
            ((SubsetIteratorFilter) bean).setSource(findValue(sourceAttr));
        }

        if (countAttr != null)
        {
            ((SubsetIteratorFilter) bean).setCount(Integer.parseInt(findString(countAttr)));
        }

        if (startAttr != null)
        {
            ((SubsetIteratorFilter) bean).setStart(Integer.parseInt(findString(startAttr)));
        }

        // Push holder back on stack
        getStack().pushValue(holder);

        return EVAL_BODY_INCLUDE;
    }
}
