/*
 * Decompiled with CFR 0.152.
 */
package webwork.action.factory;

import java.util.Map;
import webwork.action.Action;
import webwork.action.ActionContext;
import webwork.action.ApplicationAware;
import webwork.action.LocaleAware;
import webwork.action.ParameterAware;
import webwork.action.ServletRequestAware;
import webwork.action.ServletResponseAware;
import webwork.action.SessionAware;
import webwork.action.factory.ActionFactory;
import webwork.action.factory.ActionFactoryProxy;

public class ContextActionFactoryProxy
extends ActionFactoryProxy {
    Map applicationMap;

    public ContextActionFactoryProxy(ActionFactory aFactory) {
        super(aFactory);
    }

    @Override
    public Action getActionImpl(String aName) throws Exception {
        Action action = this.getNextFactory().getActionImpl(aName);
        this.setActionContext(action);
        return action;
    }

    protected void setActionContext(Object anAction) {
        ActionContext context = ActionContext.getContext();
        if (anAction instanceof ServletRequestAware) {
            ((ServletRequestAware)anAction).setServletRequest(context.getRequestImpl());
        }
        if (anAction instanceof ServletResponseAware) {
            ((ServletResponseAware)anAction).setServletResponse(context.getResponseImpl());
        }
        if (anAction instanceof SessionAware) {
            ((SessionAware)anAction).setSession(context.getSessionImpl());
        }
        if (anAction instanceof ApplicationAware) {
            ((ApplicationAware)anAction).setApplication(context.getApplicationImpl());
        }
        if (anAction instanceof ParameterAware) {
            ((ParameterAware)anAction).setParameters(context.getParametersImpl());
        }
        if (anAction instanceof LocaleAware) {
            ((LocaleAware)anAction).setLocale(context.getLocaleImpl());
        }
    }
}

