/*
 * Decompiled with CFR 0.152.
 */
package webwork.dispatcher;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webwork.action.ActionContext;
import webwork.config.Configuration;
import webwork.dispatcher.ViewActionWrapper;
import webwork.dispatcher.ViewMapping;
import webwork.util.BeanUtil;
import webwork.util.ValueStack;

public class DynamicViewMapping
implements ViewMapping {
    protected static Log log = LogFactory.getLog(DynamicViewMapping.class);
    protected ViewMapping delegate;
    protected Map cache;
    protected String actionSuffix;
    protected String actionSuffixParam;
    protected final Object NULL_VIEW = new Object();

    public DynamicViewMapping(ViewMapping aDelegate) {
        this.delegate = aDelegate;
        this.cache = Collections.synchronizedMap(new HashMap());
        try {
            this.actionSuffix = "." + Configuration.getString("webwork.action.extension");
        }
        catch (IllegalArgumentException iae) {
            this.actionSuffix = ".action";
            log.warn((Object)"Unable to find 'webwork.action.extension' property setting. Defaulting to 'action'");
        }
        this.actionSuffixParam = this.actionSuffix + "?";
    }

    @Override
    public Object getView(String anActionName, String aViewName) {
        int actionIndex;
        String cacheKey = anActionName + "." + aViewName;
        Object view = this.cache.get(cacheKey);
        if (view == this.NULL_VIEW) {
            return null;
        }
        if (view != null) {
            return view;
        }
        view = this.delegate.getView(anActionName, aViewName);
        if (view == null) {
            this.cache.put(cacheKey, this.NULL_VIEW);
            return null;
        }
        String viewString = view.toString();
        if (viewString == null) {
            this.cache.put(cacheKey, view);
            return view;
        }
        String dynamicView = this.checkDynamicView(viewString);
        if (dynamicView != null) {
            viewString = dynamicView;
            view = dynamicView;
        }
        if ((actionIndex = viewString.indexOf(this.actionSuffixParam)) != -1) {
            String newActionName = viewString.substring(0, actionIndex);
            Map parameters = this.getParams(viewString.substring(actionIndex + this.actionSuffixParam.length()));
            view = new ViewActionWrapper(newActionName, parameters);
        } else if (viewString.endsWith(this.actionSuffix)) {
            String newActionName = viewString.substring(0, viewString.length() - this.actionSuffix.length());
            view = new ViewActionWrapper(newActionName);
        }
        if (dynamicView == null) {
            this.cache.put(cacheKey, view);
        }
        return view;
    }

    protected String checkDynamicView(String view) {
        int dynEnd;
        int dynStart = view.indexOf("${");
        if (dynStart == -1) {
            return null;
        }
        StringBuilder dynView = new StringBuilder(view.length() + 40);
        ValueStack stack = ActionContext.getValueStack();
        int last = 0;
        while ((dynEnd = this.getMatchingBrace(view, dynStart + 2)) != -1) {
            String findExp = view.substring(dynStart + 2, dynEnd);
            Object value = stack.findValue(findExp);
            String valString = BeanUtil.toStringValue(value);
            if (dynStart > last) {
                dynView.append(view.substring(last, dynStart));
            }
            dynView.append(valString);
            last = dynEnd + 1;
            dynStart = view.indexOf("${", last);
            if (dynStart != -1) continue;
        }
        if (last == 0) {
            return null;
        }
        if (view.length() - 1 > last) {
            dynView.append(view.substring(last));
        }
        return dynView.toString();
    }

    protected int getMatchingBrace(String view, int dynStart) {
        int depth = 0;
        for (int i = dynStart; i < view.length(); ++i) {
            char c = view.charAt(i);
            if (c == '{') {
                ++depth;
                continue;
            }
            if (c != '}') continue;
            if (depth == 0) {
                return i;
            }
            --depth;
        }
        log.warn((Object)("No matching brace found in view: " + view + ", starting at index: " + dynStart));
        return -1;
    }

    private Map getParams(String parameterString) {
        if (parameterString == null) {
            return Collections.EMPTY_MAP;
        }
        try {
            StringTokenizer stParams = new StringTokenizer(parameterString, "&");
            HashMap<String, String> params = new HashMap<String, String>();
            while (stParams.hasMoreTokens()) {
                String nameValue = stParams.nextToken();
                int eq = nameValue.indexOf(61);
                if (eq == -1) {
                    params.put(nameValue, "");
                    continue;
                }
                String name = nameValue.substring(0, eq);
                String value = nameValue.substring(eq + 1, nameValue.length());
                params.put(name, value);
            }
            return params;
        }
        catch (NoSuchElementException nse) {
            log.warn((Object)("getParams: " + parameterString + ", caught NoSuchElementException: "), (Throwable)nse);
            return Collections.EMPTY_MAP;
        }
        catch (Exception e) {
            log.warn((Object)("getParams: " + parameterString + ", caught Exception: "), (Throwable)e);
            return Collections.EMPTY_MAP;
        }
    }
}

