/*
 * Decompiled with CFR 0.152.
 */
package webwork.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import webwork.util.QuerySegment;
import webwork.util.WebworkCacheControl;

public class Query {
    protected static ConcurrentMap<String, Query> queriesMap = new ConcurrentHashMap<String, Query>();
    public static final Query CURRENT = Query.getQuery(".");
    private static final char LPAREN = '(';
    private static final char RPAREN = ')';
    private static final char RBRACE = '}';
    private static final char LBRACE = '{';
    private static final char LBRACKET = '[';
    private static final char RBRACKET = ']';
    private static final char PARAM = '$';
    private static final char ATTR = '@';
    private static final char SLASH = '/';
    private static final char SQUOTE = '\'';
    private static final char PERIOD = '.';
    private static final char COMMA = ',';
    private static final char CONCAT = '+';
    private QuerySegment[] segments = new QuerySegment[5];
    private int segmentsIdx = 0;
    private String queryString;

    public static Query getQuery(String queryString) {
        Query query = (Query)queriesMap.get(queryString);
        if (query == null) {
            query = new Query(queryString);
            if (WebworkCacheControl.isCacheQueries()) {
                queriesMap.put(queryString, query);
            }
        }
        return query;
    }

    private Query(String queryString) {
        this.queryString = queryString.trim();
        char[] query = this.queryString.toCharArray();
        if (query.length == 0) {
            this.add(new QuerySegment(13));
            return;
        }
        if (query[0] == '.' && query.length == 1) {
            this.add(new QuerySegment(3));
            return;
        }
        if (query[0] == '/' && query.length == 1) {
            this.add(new QuerySegment(5));
            return;
        }
        if (query.length == 4 && query[0] == 't' && query[1] == 'r' && query[2] == 'u' && query[3] == 'e') {
            this.add(new QuerySegment(1));
            return;
        }
        if (query.length == 5 && query[0] == 'f' && query[1] == 'a' && query[2] == 'l' && query[3] == 's' && query[4] == 'e') {
            this.add(new QuerySegment(2));
            return;
        }
        if (query.length == 4 && query[0] == 'n' && query[1] == 'u' && query[2] == 'l' && query[3] == 'l') {
            this.add(new QuerySegment(13));
            return;
        }
        List concatList = this.splitQuery(query, '+');
        if (concatList != null) {
            QuerySegment qs = new QuerySegment(14);
            for (int i = 0; i < concatList.size(); ++i) {
                Query concatQuery = Query.getQuery((String)concatList.get(i));
                qs.addValue(concatQuery);
            }
            this.add(qs);
            return;
        }
        if (query[0] == '$') {
            String id = new String(query, 1, query.length - 1);
            this.add(new QuerySegment(id, 7));
            return;
        }
        if (query[0] < ':' && query[0] > '/' || query[0] == '-' || query[0] == '.' && query.length > 1 && query[1] < ':' && query[1] > '/') {
            try {
                String s = new String(query, 0, query.length);
                Number val = s.indexOf(46) >= 0 ? (Number)new Double(s) : (Number)new Integer(s);
                QuerySegment qs = new QuerySegment(12);
                qs.addValue(val);
                this.add(qs);
                return;
            }
            catch (NumberFormatException s) {
                // empty catch block
            }
        }
        if (query[0] == '\'') {
            if (query[query.length - 1] != '\'') {
                this.throwIllegalArgumentException(query, "missing matching end quote");
            }
            String id = new String(query, 1, query.length - 2);
            this.add(new QuerySegment(id, 0));
            return;
        }
        int queryIdx = -1;
        if (query[0] == '@') {
            for (queryIdx = 1; queryIdx < query.length && query[queryIdx] != '/' && query[queryIdx] != '['; ++queryIdx) {
            }
            String id = new String(query, 1, queryIdx - 1);
            this.add(new QuerySegment(id, 6));
            if (queryIdx == query.length) {
                return;
            }
            if (query[queryIdx] == '[') {
                --queryIdx;
            }
        }
        int[] paramIdxs = new int[10];
        do {
            int lastExprIdx = queryIdx;
            int begParenIdx = -1;
            int begBracketIdx = -1;
            int endBracketIdx = -1;
            int begBraceIdx = -1;
            int endBraceIdx = -1;
            paramIdxs[0] = -1;
            paramIdxs[1] = -1;
            paramIdxs[2] = -1;
            paramIdxs[3] = -1;
            paramIdxs[4] = -1;
            paramIdxs[5] = -1;
            paramIdxs[6] = -1;
            paramIdxs[7] = -1;
            paramIdxs[8] = -1;
            paramIdxs[9] = -1;
            int commaNbr = 0;
            int parenDepth = 0;
            int braceDepth = 0;
            int bracketDepth = 0;
            while (++queryIdx != query.length) {
                char c = query[queryIdx];
                if (c == '/') {
                    if (parenDepth > 0 || braceDepth > 0 || bracketDepth > 0) continue;
                    if (queryIdx != 0) break;
                    this.add(new QuerySegment(5));
                    lastExprIdx = 0;
                    continue;
                }
                if (c == '(') {
                    ++parenDepth;
                    if (begParenIdx >= 0 || braceDepth != 0 || bracketDepth != 0) continue;
                    begParenIdx = queryIdx;
                    continue;
                }
                if (c == ')') {
                    --parenDepth;
                    paramIdxs[commaNbr] = queryIdx;
                    continue;
                }
                if (c == '[') {
                    ++bracketDepth;
                    if (begBracketIdx >= 0 || parenDepth != 0 || braceDepth != 0) continue;
                    begBracketIdx = queryIdx;
                    continue;
                }
                if (c == ']') {
                    --bracketDepth;
                    endBracketIdx = queryIdx;
                    continue;
                }
                if (c == '{') {
                    ++braceDepth;
                    if (begBraceIdx >= 0 || parenDepth != 0 || bracketDepth != 0) continue;
                    begBraceIdx = queryIdx;
                    continue;
                }
                if (c == '}') {
                    --braceDepth;
                    endBraceIdx = queryIdx;
                    continue;
                }
                if (c == '\'') {
                    queryIdx = this.findMatchingQuote(query, queryIdx + 1);
                    continue;
                }
                if (c != ',' || parenDepth != 1) continue;
                paramIdxs[commaNbr] = queryIdx;
                ++commaNbr;
            }
            if (begBraceIdx > -1) {
                if (endBraceIdx < 0) {
                    this.throwIllegalArgumentException(query, "missing matching brace");
                }
                String id = new String(query, begBraceIdx + 1, endBraceIdx - (begBraceIdx + 1));
                Query expandQuery = Query.getQuery(id);
                this.add(new QuerySegment(id, expandQuery, 11));
            } else if (begParenIdx > -1) {
                if (paramIdxs[0] < 0) {
                    this.throwIllegalArgumentException(query, "missing matching parenthesis");
                }
                String id = new String(query, lastExprIdx + 1, begParenIdx - (lastExprIdx + 1));
                QuerySegment qs = new QuerySegment(id, 10);
                int paramStart = begParenIdx + 1;
                commaNbr = -1;
                while (paramIdxs[++commaNbr] > -1) {
                    int paramEnd = paramIdxs[commaNbr] - 1;
                    while (paramStart < paramEnd && query[paramStart] <= ' ') {
                        ++paramStart;
                    }
                    while (paramStart < paramEnd && query[paramEnd] <= ' ') {
                        --paramEnd;
                    }
                    String parameter = new String(query, paramStart, paramEnd - paramStart + 1).trim();
                    if (commaNbr == 0 && paramIdxs[commaNbr + 1] <= -1 && parameter.length() == 0) {
                        qs.createValues();
                    } else {
                        Query paramQuery = Query.getQuery(parameter);
                        qs.addValue(paramQuery);
                    }
                    paramStart = paramIdxs[commaNbr] + 1;
                }
                this.add(qs);
            } else if (lastExprIdx + 2 < query.length && query[lastExprIdx + 1] == '.' && query[lastExprIdx + 2] == '.') {
                this.add(new QuerySegment(4));
            } else if (lastExprIdx + 1 < query.length && query[lastExprIdx + 1] == '.') {
                this.add(new QuerySegment(3));
            } else if (lastExprIdx + 1 != begBracketIdx) {
                int propertyEnd = begBracketIdx > -1 ? begBracketIdx : queryIdx;
                String id = new String(query, lastExprIdx + 1, propertyEnd - (lastExprIdx + 1));
                this.add(new QuerySegment(id, 8));
            }
            if (begBracketIdx <= -1) continue;
            if (endBracketIdx < 0) {
                this.throwIllegalArgumentException(query, "missing matching bracket");
            }
            String key = new String(query, begBracketIdx + 1, endBracketIdx - (begBracketIdx + 1));
            Query queryKey = Query.getQuery(key);
            this.add(new QuerySegment(key, queryKey, 9));
        } while (queryIdx < query.length);
    }

    private char getNextChar(char[] query, int queryIdx) {
        while (++queryIdx < query.length) {
            char nextChar = query[queryIdx];
            if (nextChar == ' ') continue;
            return nextChar;
        }
        return ' ';
    }

    private List splitQuery(char[] query, char splitChar) {
        ArrayList<String> list = null;
        int begin = 0;
        for (int pos = 0; pos < query.length; ++pos) {
            char c = query[pos];
            if (c == splitChar) {
                String leftExp = new String(query, begin, pos - begin);
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(leftExp);
                begin = pos + 1;
                continue;
            }
            if (c == '\'') {
                pos = this.findMatchingQuote(query, pos + 1);
                continue;
            }
            if (c == '{') {
                pos = this.getMatchingChar(query, pos + 1, '{', '}');
                continue;
            }
            if (c == '[') {
                pos = this.getMatchingChar(query, pos + 1, '[', ']');
                continue;
            }
            if (c != '(') continue;
            pos = this.getMatchingChar(query, pos + 1, '(', ')');
        }
        if (begin > 0) {
            list.add(new String(query, begin, query.length - begin));
        }
        return list;
    }

    private int getMatchingChar(char[] query, int pos, char openChar, char closeChar) {
        int depth = 0;
        while (pos < query.length) {
            char c = query[pos];
            if (c == '\'') {
                pos = this.findMatchingQuote(query, pos + 1);
            } else if (c == openChar) {
                ++depth;
            } else if (c == closeChar) {
                if (depth == 0) {
                    return pos;
                }
                --depth;
            }
            ++pos;
        }
        this.throwIllegalArgumentException(query, "missing matching end character: " + closeChar);
        return -1;
    }

    private int findMatchingQuote(char[] query, int pos) {
        while (pos < query.length) {
            char c = query[pos];
            if (c == '\'') {
                char nextChar = this.getNextChar(query, pos);
                if (nextChar == ' ' || nextChar == ',' || nextChar == '+') {
                    return pos;
                }
                if (nextChar == ')' || nextChar == ']' || nextChar == '}') {
                    int closePos = pos;
                    while ((nextChar = this.getNextChar(query, ++closePos)) == ')' || nextChar == ']' || nextChar == '}') {
                    }
                    if (nextChar == ' ' || nextChar == ',' || nextChar == '+' || nextChar == '/') {
                        return pos;
                    }
                }
            }
            ++pos;
        }
        this.throwIllegalArgumentException(query, "missing matching end quote");
        return -1;
    }

    public QuerySegment[] getSegments() {
        return this.segments;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("query=\"").append(this.queryString).append("\"");
        for (int i = 0; i < this.segments.length; ++i) {
            QuerySegment segment = this.segments[i];
            if (segment == null) continue;
            sb.append(" {").append(segment).append("}");
        }
        return sb.toString();
    }

    private Object throwIllegalArgumentException(char[] query, String message) {
        throw new IllegalArgumentException(message + " for query: " + new String(query));
    }

    private void add(QuerySegment qs) {
        if (this.segmentsIdx == this.segments.length - 1) {
            QuerySegment[] resize = new QuerySegment[this.segments.length + 5];
            System.arraycopy(this.segments, 0, resize, 0, this.segments.length);
            this.segments = resize;
        }
        this.segments[this.segmentsIdx++] = qs;
    }
}

