/*
 * Decompiled with CFR 0.152.
 */
package webwork.util.classloader;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureClassLoader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import webwork.util.classloader.DirectoryClassLoader;
import webwork.util.classloader.JarClassLoader;

public abstract class WebworkClassLoader
extends SecureClassLoader
implements Cloneable {
    protected String[] packages = null;
    private Map cache = new HashMap();

    protected WebworkClassLoader() {
        this(ClassLoader.getSystemClassLoader());
    }

    protected WebworkClassLoader(ClassLoader parent) {
        super(parent);
    }

    public void setPackages(String[] p) {
        this.packages = p;
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class c = (Class)this.cache.get(name);
        if (c != null) {
            return c;
        }
        boolean handles = false;
        if (this.packages != null) {
            for (int i = 0; i < this.packages.length; ++i) {
                if (!name.startsWith(this.packages[i])) continue;
                handles = true;
                break;
            }
        }
        if (!handles) {
            return super.loadClass(name, resolve);
        }
        try {
            c = this.findClass(name);
        }
        catch (ClassNotFoundException ex) {
            return super.loadClass(name, resolve);
        }
        this.cache.put(name, c);
        return c;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        String path = name.replace('.', '/').concat(".class");
        byte[] data = this.getFile(path);
        if (data == null) {
            throw new ClassNotFoundException();
        }
        return this.defineClass(name, data, 0, data.length);
    }

    @Override
    protected URL findResource(String name) {
        byte[] data = this.getFile(name);
        if (data == null) {
            return null;
        }
        try {
            return this.getDataURL(name, data);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    protected abstract URL getDataURL(String var1, byte[] var2) throws MalformedURLException;

    protected Enumeration findResources(String name) {
        URL url = this.findResource(name);
        if (url == null) {
            return null;
        }
        return Collections.enumeration(Collections.singleton(url));
    }

    public abstract boolean isStale();

    protected abstract byte[] getFile(String var1);

    public static WebworkClassLoader getInstance(URL url) {
        return WebworkClassLoader.getInstance(url, ClassLoader.getSystemClassLoader());
    }

    public static WebworkClassLoader getInstance(URL url, ClassLoader parent) {
        File file = new File(url.getFile());
        WebworkClassLoader loader = file.isDirectory() ? new DirectoryClassLoader(file, parent) : new JarClassLoader(file, parent);
        return loader;
    }

    public abstract Object clone();
}

