/*
 * Decompiled with CFR 0.152.
 */
package webwork.util.injection;

import java.io.IOException;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import webwork.config.Configuration;
import webwork.util.ClassLoaderUtils;
import webwork.util.InjectionUtils;
import webwork.util.injection.DefaultObjectCreator;
import webwork.util.injection.ObjectCreator;

public class ObjectFactory {
    private static ObjectCreator impl = new DefaultObjectCreator();
    public static final String CLASS_NAME = "webwork.injection.objectcreator";

    public static Object instantiate(Class actionClass) throws IllegalAccessException, InstantiationException {
        return impl.instantiate(actionClass);
    }

    public static Object instantiateBean(ClassLoader classloader, String className) throws IOException, ClassNotFoundException {
        return impl.instantiateBean(classloader, className);
    }

    static {
        try {
            String classname = (String)Configuration.get(CLASS_NAME);
            if (classname != null && classname.length() > 0) {
                try {
                    impl = (ObjectCreator)ClassLoaderUtils.loadClass(classname, ObjectCreator.class).newInstance();
                }
                catch (Exception e) {
                    LogFactory.getLog(InjectionUtils.class).error((Object)("Could not load class " + classname + " or could not cast it to InjectionUtils.  Using default"), (Throwable)e);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (LogConfigurationException logConfigurationException) {
            // empty catch block
        }
    }
}

